/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class SubstituteFunction
implements Function {
    private static final long serialVersionUID = -1557813953499941337L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object whichValue;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 3 || parameterCount > 4) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type oldTextType = parameters.getType(1);
        Object oldTextValue = parameters.getValue(1);
        String text = typeRegistry.convertToText(textType, textValue);
        String oldText = typeRegistry.convertToText(oldTextType, oldTextValue);
        if (oldText.length() == 0) {
            return new TypeValuePair(TextType.TYPE, text);
        }
        Type newTextType = parameters.getType(2);
        Object newTextValue = parameters.getValue(2);
        String newText = typeRegistry.convertToText(newTextType, newTextValue);
        if (parameterCount == 3) {
            int oldIndex = 0;
            int index = text.indexOf(oldText);
            if (index == -1) {
                return new TypeValuePair(TextType.TYPE, text);
            }
            StringBuilder result = new StringBuilder(text.length());
            while (index >= 0) {
                result.append(text.substring(oldIndex, index));
                result.append(newText);
                oldIndex = index + oldText.length();
                index = text.indexOf(oldText, oldIndex);
            }
            result.append(text.substring(oldIndex));
            return new TypeValuePair(TextType.TYPE, result.toString());
        }
        Type whichType = parameters.getType(3);
        Number n = typeRegistry.convertToNumber(whichType, whichValue = parameters.getValue(3));
        if (n.doubleValue() < 1.0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int nthOccurence = n.intValue();
        int index = text.indexOf(oldText);
        if (index == -1) {
            return new TypeValuePair(TextType.TYPE, text);
        }
        String result = text;
        int counter = 1;
        while (index >= 0) {
            if (counter == nthOccurence) {
                StringBuilder buffer = new StringBuilder(result);
                buffer.replace(index, index + oldText.length(), newText);
                result = buffer.toString();
                return new TypeValuePair(TextType.TYPE, result);
            }
            index = result.indexOf(oldText, index + 1);
            ++counter;
        }
        return new TypeValuePair(TextType.TYPE, result);
    }

    public String getCanonicalName() {
        return "SUBSTITUTE";
    }
}

