/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.sequence.RecursiveSequence;

public class ArrayLeftFunction
implements Function {
    public String getCanonicalName() {
        return "ARRAYLEFT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int length;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Object textValue = parameters.getValue(0);
        RecursiveSequence text = new RecursiveSequence(textValue, context);
        if (parameterCount == 2) {
            Object lengthValue;
            Type lengthType = parameters.getType(1);
            Number lengthConv = typeRegistry.convertToNumber(lengthType, lengthValue = parameters.getValue(1));
            if (lengthConv.doubleValue() < 0.0) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            length = lengthConv.intValue();
        } else {
            length = 1;
        }
        ArrayList<Object> retval = new ArrayList<Object>(length);
        if (length > 0) {
            while (text.hasNext()) {
                Object o = text.next();
                retval.add(o);
                if (retval.size() != length) continue;
                break;
            }
        }
        return new TypeValuePair(AnyType.ANY_ARRAY, retval.toArray());
    }
}

