/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.pentaho.reporting.libraries.base.util.ObjectTable;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.DataTable;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class DefaultDataTable
extends ObjectTable
implements DataTable {
    private transient Boolean constant;
    private static final LValue[] EMPTY_LVALUES = new LValue[0];
    private static final long serialVersionUID = 4942690291611203409L;
    private ParsePosition parsePosition;

    public DefaultDataTable() {
        this.setData(new LValue[0][0], 0);
    }

    public DefaultDataTable(LValue[][] array) {
        if (array != null && array.length > 0) {
            int colCount = array[0].length;
            this.setData(array, colCount);
        } else {
            this.setData(new LValue[0][0], 0);
        }
    }

    public ParsePosition getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(ParsePosition parsePosition) {
        this.parsePosition = parsePosition;
    }

    public String getColumnName(int column) {
        StringBuilder result = new StringBuilder(10);
        while (column >= 0) {
            int colChar = (char)(column % 26) + 65;
            result.append(colChar);
            column = column / 26 - 1;
        }
        return result.toString();
    }

    public void setObject(int row, int column, LValue object) {
        super.setObject(row, column, (Object)object);
    }

    public LValue getValueAt(int row, int column) {
        return (LValue)this.getObject(row, column);
    }

    public void initialize(FormulaContext context) throws EvaluationException {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                LValue value = this.getValueAt(row, col);
                if (value == null) continue;
                value.initialize(context);
            }
        }
    }

    public TypeValuePair evaluate() throws EvaluationException {
        int colCount = -1;
        LValue[][] array = (LValue[][])this.getData();
        for (int i = 0; i < array.length; ++i) {
            LValue[] row = array[i];
            if (colCount > 0 && row.length != colCount) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            colCount = row.length;
        }
        return new TypeValuePair(AnyType.ANY_ARRAY, new DefaultArrayCallback(this));
    }

    public ArrayCallback getAsArray() {
        return new DefaultArrayCallback(this);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDataTable table = (DefaultDataTable)super.clone();
        Object[][] data = this.getData();
        Object[][] targetData = (Object[][])data.clone();
        for (int i = 0; i < targetData.length; ++i) {
            Object[] objects = targetData[i];
            if (objects == null) continue;
            targetData[i] = (Object[])objects.clone();
            for (int j = 0; j < objects.length; ++j) {
                LValue object = (LValue)objects[j];
                if (object == null) continue;
                objects[j] = object.clone();
            }
        }
        table.setData(targetData, this.getColumnCount());
        return table;
    }

    public Type getValueType() {
        return AnyType.ANY_ARRAY;
    }

    public LValue[] getChildValues() {
        return EMPTY_LVALUES;
    }

    public boolean isConstant() {
        if (this.constant == null) {
            this.constant = this.computeConstantValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE.equals(this.constant);
    }

    private boolean computeConstantValue() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                LValue value = this.getValueAt(row, col);
                if (value.isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int rowcount = this.getRowCount();
        int colcount = this.getColumnCount();
        b.append("{");
        for (int row = 0; row < rowcount; ++row) {
            if (row > 0) {
                b.append("|");
            }
            for (int col = 0; col < colcount; ++col) {
                if (col > 0) {
                    b.append(";");
                }
                b.append(this.getValueAt(row, col));
            }
        }
        b.append("}");
        return b.toString();
    }

    private static class DefaultArrayCallback
    implements ArrayCallback {
        private DefaultDataTable table;
        private TypeValuePair[][] backend;
        private int rowCount;
        private int columnCount;

        private DefaultArrayCallback(DefaultDataTable table) {
            this.table = table;
            this.rowCount = table.getRowCount();
            this.columnCount = table.getColumnCount();
            this.backend = new TypeValuePair[this.rowCount][this.columnCount];
        }

        public LValue getRaw(int row, int column) {
            return this.table.getValueAt(row, column);
        }

        public Object getValue(int row, int column) throws EvaluationException {
            TypeValuePair value = this.get(row, column);
            return value.getValue();
        }

        private TypeValuePair get(int row, int column) throws EvaluationException {
            if (row < 0 || row >= this.rowCount) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            if (column < 0 || column >= this.columnCount) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            try {
                TypeValuePair value = this.backend[row][column];
                if (value == null) {
                    this.backend[row][column] = value = this.getRaw(row, column).evaluate();
                }
                return value;
            }
            catch (IndexOutOfBoundsException ioe) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
        }

        public Type getType(int row, int column) throws EvaluationException {
            return this.get(row, column).getType();
        }

        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        public int getRowCount() {
            return this.table.getRowCount();
        }
    }
}

