/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import java.util.ArrayList;
import java.util.Locale;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Messages;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class TypeUtil {
    private TypeUtil() {
    }

    public static String getParameterType(Type parameterType, Locale locale) {
        Messages messages = new Messages(locale);
        if (parameterType.isFlagSet("type.date")) {
            return messages.getString("Type.Date");
        }
        if (parameterType.isFlagSet("type.logical")) {
            return messages.getString("Type.Logical");
        }
        if (parameterType.isFlagSet("type.datetime")) {
            return messages.getString("Type.Datetime");
        }
        if (parameterType.isFlagSet("type.numeric")) {
            return messages.getString("Type.Number");
        }
        if (parameterType.isFlagSet("type.numeric.sequence")) {
            return messages.getString("Type.NumberSequence");
        }
        if (parameterType.isFlagSet("unit.numeric")) {
            return messages.getString("Type.Unit");
        }
        if (parameterType.isFlagSet("type.text")) {
            return messages.getString("Type.Text");
        }
        if (parameterType.isFlagSet("type.any")) {
            return messages.getString("Type.AnyType");
        }
        return messages.getString("Type.Invalid");
    }

    public static Object[] normalize(Sequence sequence) throws EvaluationException {
        if (sequence == null) {
            return new Object[0];
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        while (sequence.hasNext()) {
            Object o = sequence.next();
            if (o == null) continue;
            retval.add(o);
        }
        return retval.toArray();
    }

    public static Object[] normalize(ArrayCallback sequence) throws EvaluationException {
        if (sequence == null) {
            return new Object[0];
        }
        ArrayList<Object> retval = new ArrayList<Object>();
        int rowCount = sequence.getRowCount();
        int colCount = sequence.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                retval.add(sequence.getValue(row, col));
            }
        }
        return retval.toArray();
    }
}

