/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;

public class AnySequence
implements Sequence {
    private int rowCursor;
    private int columnCursor;
    private LValue single;
    private ArrayCallback array;
    private FormulaContext context;

    public AnySequence(FormulaContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    public AnySequence(ArrayCallback array, FormulaContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (array == null) {
            throw new NullPointerException();
        }
        this.array = array;
        this.context = context;
    }

    public AnySequence(LValue single, FormulaContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (single == null) {
            throw new NullPointerException();
        }
        this.single = single;
        this.context = context;
    }

    protected AnySequence(AnySequence anySequence) {
        this.single = anySequence.single;
        this.context = anySequence.context;
        this.array = anySequence.array;
        this.rowCursor = anySequence.rowCursor;
        this.columnCursor = anySequence.columnCursor;
    }

    public boolean hasNext() throws EvaluationException {
        if (this.single == null && this.array == null) {
            return false;
        }
        if (this.single != null && this.rowCursor == 0) {
            return this.isValidNext(this.single);
        }
        if (this.array == null) {
            return false;
        }
        int rowCount = this.array.getRowCount();
        int columnCount = this.array.getColumnCount();
        if (this.rowCursor >= rowCount) {
            return false;
        }
        if (this.columnCursor >= columnCount) {
            this.columnCursor = 0;
        }
        while (this.rowCursor < rowCount) {
            while (this.columnCursor < columnCount) {
                LValue value = this.array.getRaw(this.rowCursor, this.columnCursor);
                if (this.isValidNext(value)) {
                    return true;
                }
                ++this.columnCursor;
            }
            this.columnCursor = 0;
            ++this.rowCursor;
        }
        return false;
    }

    protected boolean isValidNext(LValue o) throws EvaluationException {
        return o != null;
    }

    public Object next() throws EvaluationException {
        if (this.single != null && this.rowCursor == 0) {
            ++this.rowCursor;
            TypeValuePair pair = this.single.evaluate();
            return pair.getValue();
        }
        if (this.array != null) {
            Object value = this.array.getValue(this.rowCursor, this.columnCursor);
            if (this.columnCursor == this.array.getColumnCount() - 1) {
                ++this.rowCursor;
                this.columnCursor = 0;
            } else {
                ++this.columnCursor;
            }
            return value;
        }
        return null;
    }

    public LValue nextRawValue() throws EvaluationException {
        if (this.single != null && this.rowCursor == 0) {
            ++this.rowCursor;
            return this.single;
        }
        if (this.array != null) {
            LValue raw = this.array.getRaw(this.rowCursor, this.columnCursor);
            if (this.columnCursor == this.array.getColumnCount() - 1) {
                ++this.rowCursor;
                this.columnCursor = 0;
            } else {
                ++this.columnCursor;
            }
            return raw;
        }
        return null;
    }

    protected int getRowCursor() {
        return this.rowCursor;
    }

    protected int getColumnCursor() {
        return this.columnCursor;
    }

    protected LValue getSingle() {
        return this.single;
    }

    protected ArrayCallback getArray() {
        return this.array;
    }

    protected FormulaContext getContext() {
        return this.context;
    }
}

