/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.market.place;

import java.util.ArrayList;
import java.util.List;
import org.apache.batik.xml.XMLException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marketplace
implements XMLInterface {
    public static String XML_TAG = "marketplace";
    private String name;
    private String entriesUrl;

    public Marketplace() {
    }

    public Marketplace(String name, String entriesUrl) {
        this();
        this.name = name;
        this.entriesUrl = entriesUrl;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Marketplace)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return ((Marketplace)obj).getName().equalsIgnoreCase(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getXML() throws KettleException {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.name));
        xml.append(XMLHandler.addTagValue((String)"entries_url", (String)this.entriesUrl));
        xml.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public Marketplace(Node node) throws XMLException {
        this();
        this.name = XMLHandler.getTagValue((Node)node, (String)"name");
        this.entriesUrl = XMLHandler.getTagValue((Node)node, (String)"entries_url");
    }

    public static final List<Marketplace> getDefaultMarketplaces() {
        ArrayList<Marketplace> marketplaces = new ArrayList<Marketplace>();
        marketplaces.add(new Marketplace("Pentaho Data Integration Marketplace", "https://raw.github.com/pentaho/marketplace-metadata/master/marketplace.xml"));
        return marketplaces;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEntriesUrl() {
        return this.entriesUrl;
    }

    public void setEntriesUrl(String entriesUrl) {
        this.entriesUrl = entriesUrl;
    }
}

