/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.market.Market;
import org.pentaho.di.core.market.entry.MarketEntries;
import org.pentaho.di.core.market.entry.MarketEntry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class MarketplaceDialog
extends Dialog {
    private static Class<?> MARKET_PKG = Market.class;
    private Label wlMarketplaces;
    private Button wClose;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private ExpandBar bar;
    private int margin;
    private int middle;

    public MarketplaceDialog(Shell parent) {
        super(parent, 0);
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("PDI Marketplace");
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        this.margin = 4;
        this.middle = this.props.getMiddlePct();
        this.wlMarketplaces = new Label((Composite)this.shell, 0);
        this.wlMarketplaces.setText("Detected plugins");
        this.props.setLook((Control)this.wlMarketplaces);
        FormData fdlMarketplaces = new FormData();
        fdlMarketplaces.left = new FormAttachment(0, 0);
        fdlMarketplaces.top = new FormAttachment(0, this.margin);
        this.wlMarketplaces.setLayoutData((Object)fdlMarketplaces);
        this.bar = new ExpandBar((Composite)this.shell, 768);
        FormData fdBar = new FormData();
        fdBar.left = new FormAttachment(0, 0);
        fdBar.top = new FormAttachment((Control)this.wlMarketplaces, this.margin);
        fdBar.right = new FormAttachment(100, 0);
        fdBar.bottom = new FormAttachment(100, -50);
        this.bar.setLayoutData((Object)fdBar);
        MarketEntries marketEntries = new MarketEntries();
        for (final MarketEntry marketEntry : marketEntries) {
            Image image;
            Composite composite = new Composite((Composite)this.bar, 0);
            FormLayout layout = new FormLayout();
            layout.marginHeight = this.margin;
            layout.marginWidth = this.margin;
            composite.setLayout((Layout)layout);
            this.props.setLook((Control)composite);
            Control lastControl = null;
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.ID.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getId(), (String)""), lastControl);
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Name.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getName(), (String)""), lastControl);
            if (!Const.isEmpty((String)marketEntry.getDescription())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Description.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightLabel(composite, marketEntry.getDescription(), lastControl);
            }
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.PackageURL.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightURL(composite, marketEntry.getPackageUrl(), lastControl);
            if (!Const.isEmpty((String)marketEntry.getDocumentationUrl())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Documentation.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightURL(composite, marketEntry.getDocumentationUrl(), lastControl);
            }
            if (!Const.isEmpty((String)marketEntry.getCasesUrl())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.CaseTracking.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightURL(composite, marketEntry.getCasesUrl(), lastControl);
            }
            if (!Const.isEmpty((String)marketEntry.getSourceUrl())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SourceCode.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightURL(composite, marketEntry.getSourceUrl(), lastControl);
            }
            if (!Const.isEmpty((String)marketEntry.getLicenseName())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.License.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getLicenseName(), (String)""), lastControl);
            }
            if (!Const.isEmpty((String)marketEntry.getLicenseText())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.LicenseDetails.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getLicenseText(), (String)""), lastControl);
            }
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SupportLevel.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, marketEntry.getSupportLevel().getDescription(), lastControl);
            if (!Const.isEmpty((String)marketEntry.getSupportMessage())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SupportMessage.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightLabel(composite, marketEntry.getSupportMessage(), lastControl);
            }
            if (!Const.isEmpty((String)marketEntry.getSupportUrl())) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SupportURL.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightURL(composite, marketEntry.getSupportUrl(), lastControl);
            }
            Market.discoverInstalledVersion(marketEntry);
            if (marketEntry.isInstalled()) {
                this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Version.label", (String[])new String[0]), lastControl);
                lastControl = this.addRightLabel(composite, marketEntry.getInstalledVersion(), lastControl);
            }
            final Button button = new Button(composite, 8);
            final ExpandItem expandItem = new ExpandItem(this.bar, 0, 0);
            this.setButtonLabel(button, marketEntry.isInstalled());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        if (marketEntry.getId().equals("market")) {
                            MessageBox mb = new MessageBox(MarketplaceDialog.this.shell, 200);
                            mb.setMessage(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UninstallMarket.Message", (String[])new String[0]));
                            mb.setText(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UninstallMarket.Title", (String[])new String[0]));
                            int id = mb.open();
                            if (id == 64) {
                                MarketplaceDialog.this.dispose();
                                Market.uninstallMarket();
                            }
                        } else {
                            Market.installUninstall(marketEntry, marketEntry.isInstalled());
                            Market.discoverInstalledVersion(marketEntry);
                            MarketplaceDialog.this.setButtonLabel(button, marketEntry.isInstalled());
                            MarketplaceDialog.this.setPluginName(expandItem, marketEntry.getName(), marketEntry.isInstalled());
                        }
                    }
                    catch (KettleException ke) {
                        new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), (Exception)((Object)ke));
                    }
                }
            });
            if (marketEntry.getInstalledVersion() != marketEntry.getVersion()) {
                final Button upgradeButton = new Button(composite, 8);
                upgradeButton.setText(BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.UpgradeTo.button", (String[])new String[]{marketEntry.getVersion()}));
                upgradeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            if (marketEntry.getId().equals("market")) {
                                MessageBox mb = new MessageBox(MarketplaceDialog.this.shell, 200);
                                mb.setMessage(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UpgradeMarket.Message", (String[])new String[0]));
                                mb.setText(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UpgradeMarket.Title", (String[])new String[0]));
                                int id = mb.open();
                                if (id == 64) {
                                    MarketplaceDialog.this.dispose();
                                    Market.upgradeMarket(marketEntry);
                                }
                            } else {
                                Market.install(marketEntry);
                                upgradeButton.setEnabled(false);
                            }
                        }
                        catch (KettleException ke) {
                            new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), (Exception)((Object)ke));
                        }
                    }
                });
                BaseStepDialog.positionBottomButtons((Composite)composite, (Button[])new Button[]{button, upgradeButton}, (int)this.margin, (Control)lastControl);
            } else {
                BaseStepDialog.positionBottomButtons((Composite)composite, (Button[])new Button[]{button}, (int)this.margin, (Control)lastControl);
            }
            Label wlName = new Label(composite, 16384);
            this.props.setLook((Control)wlName);
            wlName.setText("Name:");
            FormData fdlName = new FormData();
            fdlName.top = new FormAttachment(0, 0);
            fdlName.left = new FormAttachment(0, 0);
            fdlName.right = new FormAttachment(this.middle, 0);
            wlName.setLayoutData((Object)fdlName);
            this.setPluginName(expandItem, marketEntry.getName(), marketEntry.isInstalled());
            expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
            expandItem.setControl((Control)composite);
            switch (marketEntry.getType()) {
                case Step: {
                    image = GUIResource.getInstance().getImageTransGraph();
                    break;
                }
                case JobEntry: {
                    image = GUIResource.getInstance().getImageTransGraph();
                    break;
                }
                case SpoonPlugin: {
                    image = GUIResource.getInstance().getImageTransGraph();
                    break;
                }
                case Database: {
                    image = GUIResource.getInstance().getImageConnection();
                    break;
                }
                default: {
                    image = GUIResource.getInstance().getImageSpoon();
                }
            }
            expandItem.setImage(image);
        }
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(MARKET_PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.wClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceDialog.this.dispose();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wClose}, (int)this.margin, null);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MarketplaceDialog.this.dispose();
            }
        });
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void setButtonLabel(Button button, boolean isInstalled) {
        if (isInstalled) {
            button.setText("  Uninstall this plugin  ");
        } else {
            button.setText("  Install this plugin  ");
        }
    }

    private void setPluginName(ExpandItem expandItem, String name, boolean isInstalled) {
        if (isInstalled) {
            expandItem.setText(BaseMessages.getString(MARKET_PKG, (String)"Marketplaces.Dialog.PluginInstalled.message", (String[])new String[]{name}));
        } else {
            expandItem.setText(BaseMessages.getString(MARKET_PKG, (String)"Marketplaces.Dialog.PluginNotInstalled.message", (String[])new String[]{name}));
        }
    }

    private void addLeftLabel(Composite composite, String string, Control lastControl) {
        Label label = new Label(composite, 131072);
        this.props.setLook((Control)label);
        if (string == null) {
            string = "null";
        }
        label.setText(string);
        label.setFont(GUIResource.getInstance().getFontBold());
        FormData fdLabel = new FormData();
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, 2 * this.margin) : new FormAttachment(0, 0);
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(this.middle / 2, 0);
        label.setLayoutData((Object)fdLabel);
    }

    private Control addRightLabel(Composite composite, String string, Control lastControl) {
        Label label = new Label(composite, 16384);
        this.props.setLook((Control)label);
        if (string == null) {
            string = "null";
        }
        label.setText(string);
        FormData fdLabel = new FormData();
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, 2 * this.margin) : new FormAttachment(0, 0);
        fdLabel.left = new FormAttachment(this.middle / 2, this.margin);
        fdLabel.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)fdLabel);
        return label;
    }

    private Control addRightURL(Composite composite, final String string, Control lastControl) {
        Link link = new Link(composite, 16384);
        this.props.setLook((Control)link);
        link.setText("<a>" + string + "</a>");
        FormData fdLabel = new FormData();
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, 2 * this.margin) : new FormAttachment(0, 0);
        fdLabel.left = new FormAttachment(this.middle / 2, this.margin);
        fdLabel.right = new FormAttachment(100, 0);
        link.setLayoutData((Object)fdLabel);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Spoon.getInstance().addSpoonBrowser(string, string);
            }
        });
        return link;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

