/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.wizard.model.ElementFormatDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.FieldDefinition;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class WizardOverrideFormattingFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private LFUMap expressionsCache = new LFUMap(500);

    protected void processRootBand(Band b) {
        NeedEvalResult needToRun = (NeedEvalResult)this.expressionsCache.get((Object)b.getObjectID());
        if (needToRun != null && !needToRun.isNeedToRun() && b.getChangeTracker() == needToRun.getChangeTracker()) {
            return;
        }
        boolean needToRunVal = this.processBand(b);
        this.expressionsCache.put((Object)b.getObjectID(), (Object)new NeedEvalResult(needToRunVal, b.getChangeTracker()));
    }

    private boolean processBand(Band b) {
        boolean hasAttrExpressions = this.evaluateElement((Element)b);
        if (!b.isVisible()) {
            return hasAttrExpressions;
        }
        for (Element element : b.unsafeGetElementArray()) {
            if (element instanceof Band) {
                if (!this.processBand((Band)element)) continue;
                hasAttrExpressions = true;
                continue;
            }
            if (!this.evaluateElement(element)) continue;
            hasAttrExpressions = true;
        }
        if (b instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)b;
            SubReport[] reports = rlb.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport subReport = reports[i];
                if (!this.evaluateElement((Element)subReport)) continue;
                hasAttrExpressions = true;
            }
        }
        return hasAttrExpressions;
    }

    public int getProcessingPriority() {
        return 6000;
    }

    protected boolean evaluateElement(Element e) {
        Object maybeFieldData;
        if (e == null) {
            throw new NullPointerException();
        }
        boolean retval = false;
        Object maybeFormatData = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData");
        if (maybeFormatData instanceof ElementFormatDefinition) {
            ElementFormatDefinition formatDefinition = (ElementFormatDefinition)maybeFormatData;
            if (formatDefinition.getBackgroundColor() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)formatDefinition.getBackgroundColor());
                retval = true;
            }
            if (formatDefinition.getFontColor() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)formatDefinition.getFontColor());
                retval = true;
            }
            if (formatDefinition.getFontBold() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)formatDefinition.getFontBold());
                retval = true;
            }
            if (formatDefinition.getFontItalic() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.ITALIC, (Object)formatDefinition.getFontItalic());
                retval = true;
            }
            if (formatDefinition.getFontName() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)formatDefinition.getFontName());
                retval = true;
            }
            if (formatDefinition.getFontUnderline() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, (Object)formatDefinition.getFontUnderline());
                retval = true;
            }
            if (formatDefinition.getFontItalic() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.ITALIC, (Object)formatDefinition.getFontItalic());
                retval = true;
            }
            if (formatDefinition.getFontSize() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)formatDefinition.getFontSize());
                retval = true;
            }
            if (formatDefinition.getFontStrikethrough() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, (Object)formatDefinition.getFontStrikethrough());
                retval = true;
            }
            if (formatDefinition.getHorizontalAlignment() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)formatDefinition.getHorizontalAlignment());
                retval = true;
            }
            if (formatDefinition.getVerticalAlignment() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)formatDefinition.getVerticalAlignment());
                retval = true;
            }
        }
        if ((maybeFieldData = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData")) instanceof FieldDefinition) {
            FieldDefinition fieldDefinition = (FieldDefinition)maybeFieldData;
            if (fieldDefinition.getDataFormat() != null) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", (Object)fieldDefinition.getDataFormat());
                retval = true;
            }
            if (fieldDefinition.getNullString() != null) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", (Object)fieldDefinition.getNullString());
                retval = true;
            }
            if ("label".equals(e.getElementTypeName()) && !StringUtils.isEmpty((String)fieldDefinition.getDisplayName())) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)fieldDefinition.getDisplayName());
            }
        }
        return retval;
    }

    public int getDependencyLevel() {
        return -2;
    }

    public Expression getInstance() {
        WizardOverrideFormattingFunction eval = (WizardOverrideFormattingFunction)super.getInstance();
        eval.expressionsCache = new LFUMap(500);
        return eval;
    }

    private static class NeedEvalResult {
        private boolean needToRun;
        private long changeTracker;

        private NeedEvalResult(boolean needToRun, long changeTracker) {
            this.needToRun = needToRun;
            this.changeTracker = changeTracker;
        }

        public boolean isNeedToRun() {
            return this.needToRun;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }
    }
}

