/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultProcessingContext;
import org.pentaho.reporting.engine.classic.core.states.StateUtilities;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessor;
import org.pentaho.reporting.engine.classic.wizard.model.GroupType;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class WizardProcessorUtil {
    private WizardProcessorUtil() {
    }

    public static boolean isCacheEnabled(ReportDefinition reportDefinition) {
        while (reportDefinition != null) {
            Object dataCacheEnabledRaw = reportDefinition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
            if (Boolean.FALSE.equals(dataCacheEnabledRaw)) {
                return false;
            }
            Section parentSection = reportDefinition.getParentSection();
            if (parentSection == null) break;
            reportDefinition = parentSection.getReportDefinition();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubReport materialize(SubReport report, WizardProcessor processor) throws ReportProcessingException {
        MasterReport masterReport = DesignTimeUtil.getMasterReport((Element)report);
        DefaultProcessingContext processingContext = masterReport != null ? new DefaultProcessingContext(masterReport) : new DefaultProcessingContext();
        DataSchemaDefinition definition = report.getDataSchemaDefinition();
        DefaultFlowController flowController = new DefaultFlowController((ProcessingContext)processingContext, definition, StateUtilities.computeParameterValueSet((SubReport)report), null, false);
        CachingDataFactory dataFactory = new CachingDataFactory(report.getDataFactory(), WizardProcessorUtil.isCacheEnabled((ReportDefinition)report));
        dataFactory.initialize(processingContext.getConfiguration(), processingContext.getResourceManager(), DesignTimeUtil.getContextKey((AbstractReportDefinition)report), processingContext.getResourceBundleFactory());
        dataFactory.open();
        try {
            DefaultFlowController postQueryFlowController = flowController.performQuery((DataFactory)dataFactory, report.getQuery(), report.getQueryLimit(), report.getQueryTimeout(), flowController.getMasterRow().getResourceBundleFactory());
            Object originalEnable = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable");
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable", (Object)Boolean.TRUE);
            SubReport subReport = processor.performPreProcessing(report, postQueryFlowController);
            subReport.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable", originalEnable);
            SubReport subReport2 = subReport;
            return subReport2;
        }
        finally {
            dataFactory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MasterReport materialize(MasterReport report, WizardProcessor processor) throws ReportProcessingException {
        DefaultProcessingContext processingContext = new DefaultProcessingContext(report);
        DataSchemaDefinition definition = report.getDataSchemaDefinition();
        DefaultFlowController flowController = new DefaultFlowController((ProcessingContext)processingContext, definition, StateUtilities.computeParameterValueSet((MasterReport)report), report.getParameterDefinition().getParameterDefinitions(), false);
        CachingDataFactory dataFactory = new CachingDataFactory(report.getDataFactory(), WizardProcessorUtil.isCacheEnabled((ReportDefinition)report));
        dataFactory.initialize(processingContext.getConfiguration(), processingContext.getResourceManager(), processingContext.getContentBase(), processingContext.getResourceBundleFactory());
        dataFactory.open();
        try {
            DefaultFlowController postQueryFlowController = flowController.performQuery((DataFactory)dataFactory, report.getQuery(), report.getQueryLimit(), report.getQueryTimeout(), flowController.getMasterRow().getResourceBundleFactory());
            Object originalEnable = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable");
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable", (Object)Boolean.TRUE);
            MasterReport masterReport = processor.performPreProcessing(report, postQueryFlowController);
            masterReport.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable", originalEnable);
            masterReport.setName(null);
            DesignTimeUtil.resetDocumentMetaData((MasterReport)masterReport);
            MasterReport masterReport2 = masterReport;
            return masterReport2;
        }
        finally {
            dataFactory.close();
        }
    }

    public static void resetDocumentMetaData(MasterReport masterReport) {
        DesignTimeUtil.resetDocumentMetaData((MasterReport)masterReport);
    }

    public static void ensureWizardProcessorIsAdded(AbstractReportDefinition element, WizardProcessor processor) {
        ReportPreProcessor[] processors = element.getPreProcessors();
        boolean hasWizardProcessor = false;
        for (int i = 0; i < processors.length; ++i) {
            ReportPreProcessor preProcessor = processors[i];
            if (!(preProcessor instanceof WizardProcessor)) continue;
            hasWizardProcessor = true;
        }
        if (!hasWizardProcessor) {
            if (processor == null) {
                element.addPreProcessor((ReportPreProcessor)new WizardProcessor());
            } else {
                element.addPreProcessor((ReportPreProcessor)processor);
            }
        }
    }

    public static void applyWizardSpec(AbstractReportDefinition definition, WizardSpecification wizardSpecification) {
        definition.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "wizard-spec", (Object)wizardSpecification);
    }

    public static WizardSpecification loadWizardSpecification(AbstractReportDefinition definition, ResourceManager resourceManager) throws ReportProcessingException {
        Object maybeWizardSpec = definition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "wizard-spec");
        if (maybeWizardSpec instanceof WizardSpecification) {
            return (WizardSpecification)maybeWizardSpec;
        }
        Object attribute = definition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "source");
        if (attribute != null) {
            try {
                ResourceKey contentBase = definition.getContentBase();
                ResourceKey resourceKey = resourceManager.deriveKey(contentBase, String.valueOf(attribute));
                Resource resource = resourceManager.create(resourceKey, contentBase, WizardSpecification.class);
                return (WizardSpecification)resource.getResource();
            }
            catch (ResourceKeyCreationException e) {
                throw new ReportProcessingException("Failed to load the wizard-specification", (Exception)((Object)e));
            }
            catch (ResourceException e) {
                throw new ReportProcessingException("Failed to load the wizard-specification", (Exception)((Object)e));
            }
        }
        try {
            ResourceKey contentBase = definition.getContentBase();
            ResourceKey resourceKey = resourceManager.deriveKey(contentBase, "wizard-specification.xml");
            Resource resource = resourceManager.create(resourceKey, contentBase, WizardSpecification.class);
            return (WizardSpecification)resource.getResource();
        }
        catch (ResourceKeyCreationException e) {
        }
        catch (ResourceLoadingException e) {
        }
        catch (ResourceException e) {
            throw new ReportProcessingException("Failed to load the wizard-specification", (Exception)((Object)e));
        }
        return null;
    }

    public static boolean isGroupMatchesType(Group group, GroupType type) {
        return GroupType.RELATIONAL.equals(type) ? group instanceof RelationalGroup : (GroupType.CT_COLUMN.equals(type) ? group instanceof CrosstabColumnGroup : GroupType.CT_ROW.equals(type) && group instanceof CrosstabRowGroup);
    }
}

