/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.model;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.util.ObjectStreamResolveException;

public final class LengthUnit
implements Serializable {
    public static final LengthUnit POINTS = new LengthUnit("pt", 1.0);
    public static final LengthUnit PERCENTAGE = new LengthUnit("%", -1.0);
    public static final LengthUnit PICA = new LengthUnit("pc", 12.0);
    public static final LengthUnit MM = new LengthUnit("mm", 2.834645669291339);
    public static final LengthUnit CM = new LengthUnit("cm", 28.346456692913385);
    public static final LengthUnit INCH = new LengthUnit("in", 72.0);
    private double dotsPerUnit;
    private String name;

    private LengthUnit(String name, double dotsPerUnit) {
        this.name = name;
        this.dotsPerUnit = dotsPerUnit;
    }

    public String getName() {
        return this.name;
    }

    public double getDotsPerUnit() {
        return this.dotsPerUnit;
    }

    public double convertFromPoints(double points) {
        return points / this.dotsPerUnit;
    }

    public double convertToPoints(double unit) {
        return unit * this.dotsPerUnit;
    }

    public static LengthUnit[] values() {
        return new LengthUnit[]{INCH, CM, MM, PICA, PERCENTAGE, POINTS};
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.dotsPerUnit == LengthUnit.INCH.dotsPerUnit) {
            return INCH;
        }
        if (this.dotsPerUnit == LengthUnit.CM.dotsPerUnit) {
            return CM;
        }
        if (this.dotsPerUnit == LengthUnit.MM.dotsPerUnit) {
            return MM;
        }
        if (this.dotsPerUnit == LengthUnit.PICA.dotsPerUnit) {
            return PICA;
        }
        if (this.dotsPerUnit == LengthUnit.PERCENTAGE.dotsPerUnit) {
            return PERCENTAGE;
        }
        if (this.dotsPerUnit == LengthUnit.POINTS.dotsPerUnit) {
            return POINTS;
        }
        throw new ObjectStreamResolveException();
    }
}

