/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.writer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.DetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.writer.DetailFieldDefinitionWriteHandler;
import org.pentaho.reporting.engine.classic.wizard.writer.GroupDefinitionWriteHandler;
import org.pentaho.reporting.engine.classic.wizard.writer.RootBandWriterHandler;
import org.pentaho.reporting.engine.classic.wizard.writer.WatermarkDefinitionWriterHandler;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class WizardSpecificationWriteHandler
implements BundleWriterHandler {
    public int getProcessingOrder() {
        return 100000;
    }

    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        AbstractReportDefinition report = state.getReport();
        try {
            WizardSpecification specification = WizardProcessorUtil.loadWizardSpecification(report, state.getMasterReport().getResourceManager());
            if (specification == null) {
                return null;
            }
            BundleWriterState wizardFileState = new BundleWriterState(state, "wizard-specification.xml");
            BufferedOutputStream outputStream = new BufferedOutputStream(bundle.createEntry(wizardFileState.getFileName(), "text/xml"));
            DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.wizard.tag-def.");
            XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
            AttributeList rootAttrs = new AttributeList();
            rootAttrs.addNamespaceDeclaration("wizard", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/wizard-specification/1.0");
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/wizard-specification/1.0", "wizard-specification", rootAttrs, false);
            RootBandWriterHandler rootBandWriterHandler = new RootBandWriterHandler();
            rootBandWriterHandler.writeReport(bundle, wizardFileState, xmlWriter, specification.getColumnHeader(), "column-header");
            rootBandWriterHandler.writeReport(bundle, wizardFileState, xmlWriter, specification.getColumnFooter(), "column-footer");
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/wizard-specification/1.0", "detail-fields", false);
            DetailFieldDefinition[] detailFieldDefinitions = specification.getDetailFieldDefinitions();
            DetailFieldDefinitionWriteHandler detailWriteHandler = new DetailFieldDefinitionWriteHandler();
            for (int i = 0; i < detailFieldDefinitions.length; ++i) {
                DetailFieldDefinition definition = detailFieldDefinitions[i];
                detailWriteHandler.writeReport(bundle, wizardFileState, xmlWriter, definition);
            }
            xmlWriter.writeCloseTag();
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/wizard-specification/1.0", "group-definitions", false);
            GroupDefinition[] groupDefinitions = specification.getGroupDefinitions();
            GroupDefinitionWriteHandler groupDefinitionWriteHandler = new GroupDefinitionWriteHandler();
            for (int i = 0; i < groupDefinitions.length; ++i) {
                GroupDefinition definition = groupDefinitions[i];
                groupDefinitionWriteHandler.writeReport(bundle, wizardFileState, xmlWriter, definition);
            }
            xmlWriter.writeCloseTag();
            WatermarkDefinitionWriterHandler watermarkDefinitionWriterHandler = new WatermarkDefinitionWriterHandler();
            watermarkDefinitionWriterHandler.writeReport(bundle, wizardFileState, xmlWriter, specification.getWatermarkDefinition());
            xmlWriter.writeCloseTag();
            xmlWriter.close();
            return wizardFileState.getFileName();
        }
        catch (ReportProcessingException e) {
            throw new BundleWriterException("Failed to load wizard-specifiation", (Exception)((Object)e));
        }
    }
}

