/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.pentaho.reporting.libraries.pixie.wmf.WmfObject;

public class MfLogPen
implements WmfObject {
    private static final float[] DASH_DASH = new float[]{6.0f, 2.0f};
    private static final float[] DASH_DOT = new float[]{2.0f, 2.0f};
    private static final float[] DASH_DASHDOT = new float[]{6.0f, 2.0f, 2.0f, 2.0f};
    private static final float[] DASH_DASHDOTDOT = new float[]{6.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f};
    private int style = 0;
    private int endCap;
    private int joinType;
    private int width = 0;
    private Color color = Color.black;

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style & 0xFF;
        this.endCap = style & 0xF00;
        this.joinType = style & 0xF000;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isSimpleStyle() {
        switch (this.style) {
            case 0: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this.getStyle() != 5;
    }

    public int getType() {
        return 1;
    }

    public Stroke getStroke() {
        if (this.isSimpleStyle()) {
            return new BasicStroke(this.getWidth(), this.getEndCap(), this.getJoinType(), 0.0f);
        }
        return new BasicStroke(this.getWidth(), this.getEndCap(), this.getJoinType(), 0.0f, this.getDashes(), 0.0f);
    }

    private int getJoinType() {
        switch (this.joinType) {
            case 0: {
                return 1;
            }
            case 4096: {
                return 2;
            }
            case 8192: {
                return 0;
            }
        }
        return 1;
    }

    private int getEndCap() {
        switch (this.endCap) {
            case 0: {
                return 1;
            }
            case 256: {
                return 2;
            }
            case 512: {
                return 0;
            }
        }
        return 1;
    }

    private float[] getDashes() {
        switch (this.getStyle()) {
            case 1: {
                return DASH_DASH;
            }
            case 2: {
                return DASH_DOT;
            }
            case 3: {
                return DASH_DASHDOT;
            }
            case 4: {
                return DASH_DASHDOTDOT;
            }
        }
        throw new IllegalStateException("Illegal Pen defined");
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append("MfLogPen:=");
        b.append(" width=");
        b.append(this.getWidth());
        b.append(" style=");
        b.append(this.getStyle());
        b.append(" color=");
        b.append(this.getColor());
        return b.toString();
    }
}

