/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfHeader;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogBrush;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogPen;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfPalette;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfObject;
import org.pentaho.reporting.libraries.pixie.wmf.records.CommandFactory;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmdSetWindowExt;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmdSetWindowOrg;

public class WmfFile {
    private static final Log logger = LogFactory.getLog(WmfFile.class);
    public static final int QUALITY_NO = 0;
    public static final int QUALITY_MAYBE = 1;
    public static final int QUALITY_YES = 2;
    private static final int MAX_PICTURE_SIZE = WmfFile.getMaxPictureSize();
    private WmfObject[] objects;
    private FastStack dcStack;
    private MfPalette palette;
    private InputStream in;
    private MfHeader header;
    private int fileSize;
    private int filePos;
    private ArrayList records;
    private Graphics2D graphics;
    private int maxWidth;
    private int maxHeight;
    private int imageWidth;
    private int imageHeight;
    private int minX;
    private int minY;
    private int imageX;
    private int imageY;

    private static int getMaxPictureSize() {
        return 1200;
    }

    public WmfFile(URL input) throws IOException {
        this(input, -1, -1);
    }

    public WmfFile(String input) throws IOException {
        this(input, -1, -1);
    }

    public WmfFile(URL input, int imageWidth, int imageHeight) throws IOException {
        this(new BufferedInputStream(input.openStream()), imageWidth, imageHeight);
    }

    public WmfFile(String inName, int imageWidth, int imageHeight) throws FileNotFoundException, IOException {
        this(new BufferedInputStream(new FileInputStream(inName)), imageWidth, imageHeight);
    }

    public WmfFile(InputStream in, int imageWidth, int imageHeight) throws IOException {
        this.in = in;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.records = new ArrayList();
        this.dcStack = new FastStack(100);
        this.palette = new MfPalette();
        this.readHeader();
        this.parseRecords();
        this.resetStates();
    }

    public Dimension getImageSize() {
        return new Dimension(this.maxWidth, this.maxHeight);
    }

    private void resetStates() {
        Arrays.fill(this.objects, null);
        this.dcStack.clear();
        this.dcStack.push((Object)new MfDcState(this));
    }

    public MfPalette getPalette() {
        return this.palette;
    }

    public MfHeader getHeader() {
        return this.header;
    }

    public Graphics2D getGraphics2D() {
        return this.graphics;
    }

    private void assertValid() {
        if (this.filePos < 0 || this.filePos > this.fileSize) {
            throw new IllegalStateException("WmfFile is not valid");
        }
    }

    private MfHeader readHeader() throws IOException {
        this.header = new MfHeader();
        this.header.read(this.in);
        if (this.header.isValid()) {
            this.fileSize = this.header.getFileSize();
            this.objects = new WmfObject[this.header.getObjectsSize()];
            this.filePos = this.header.getHeaderSize();
            return this.header;
        }
        throw new IOException("The given file is not a real metafile");
    }

    private MfRecord readNextRecord() throws IOException {
        if (this.filePos >= this.fileSize) {
            return null;
        }
        this.assertValid();
        MfRecord record = new MfRecord(this.in);
        this.filePos += record.getLength();
        return record;
    }

    private void parseRecords() throws IOException {
        MfRecord mf;
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxWidth = 0;
        this.maxHeight = 0;
        CommandFactory cmdFactory = CommandFactory.getInstance();
        while ((mf = this.readNextRecord()) != null) {
            MfCmd worg;
            MfCmd cmd = cmdFactory.getCommand(mf.getType());
            if (cmd == null) {
                logger.info((Object)("Failed to parse record " + mf.getType()));
                continue;
            }
            cmd.setRecord(mf);
            if (cmd.getFunction() == 523) {
                worg = (MfCmdSetWindowOrg)cmd;
                Point p = ((MfCmdSetWindowOrg)worg).getTarget();
                this.minX = Math.min(p.x, this.minX);
                this.minY = Math.min(p.y, this.minY);
            } else if (cmd.getFunction() == 524) {
                worg = (MfCmdSetWindowExt)cmd;
                Dimension d = ((MfCmdSetWindowExt)worg).getDimension();
                this.maxWidth = Math.max(this.maxWidth, d.width);
                this.maxHeight = Math.max(this.maxHeight, d.height);
            }
            this.records.add(cmd);
        }
        this.in.close();
        this.in = null;
        if (this.minX == Integer.MAX_VALUE) {
            this.minX = 0;
        }
        if (this.minY == Integer.MAX_VALUE) {
            this.minY = 0;
        }
        if (this.imageWidth < 1 || this.imageHeight < 1) {
            this.scaleToFit(MAX_PICTURE_SIZE, MAX_PICTURE_SIZE);
        } else {
            this.scaleToFit(this.imageWidth, this.imageHeight);
        }
    }

    public void scaleToFit(float fitWidth, float fitHeight) {
        float percentX = fitWidth * 100.0f / (float)this.maxWidth;
        float percentY = fitHeight * 100.0f / (float)this.maxHeight;
        this.scalePercent(percentX < percentY ? percentX : percentY);
    }

    public void scalePercent(float percent) {
        this.scalePercent(percent, percent);
    }

    public void scalePercent(float percentX, float percentY) {
        this.imageWidth = (int)((float)this.maxWidth * percentX / 100.0f);
        this.imageHeight = (int)((float)this.maxHeight * percentY / 100.0f);
        this.imageX = (int)((float)this.minX * percentX / 100.0f);
        this.imageY = (int)((float)this.minY * percentY / 100.0f);
    }

    public static void main(String[] args) throws Exception {
        WmfFile wmf = new WmfFile("./head/pixie/res/a0.wmf", 800, 600);
        wmf.replay();
    }

    public MfDcState getCurrentState() {
        return (MfDcState)this.dcStack.peek();
    }

    public void saveDCState() {
        MfDcState currentState = this.getCurrentState();
        this.dcStack.push((Object)new MfDcState(currentState));
    }

    public int getStateCount() {
        return this.dcStack.size();
    }

    public void restoreDCState(int stateCount) {
        if (!(stateCount > 0)) {
            throw new IllegalArgumentException();
        }
        this.dcStack.pop();
        this.getCurrentState().restoredState();
    }

    protected int findFreeSlot() {
        for (int slot = 0; slot < this.objects.length; ++slot) {
            if (this.objects[slot] != null) continue;
            return slot;
        }
        throw new IllegalStateException("No free slot");
    }

    public void storeObject(WmfObject o) {
        int idx = this.findFreeSlot();
        this.objects[idx] = o;
    }

    public void deleteObject(int slot) {
        if (slot < 0 || slot >= this.objects.length) {
            throw new IllegalArgumentException("Range violation");
        }
        this.objects[slot] = null;
    }

    public WmfObject getObject(int slot) {
        if (slot < 0 || slot >= this.objects.length) {
            throw new IllegalStateException("Range violation");
        }
        return this.objects[slot];
    }

    public MfLogBrush getBrushObject(int slot) {
        WmfObject obj = this.getObject(slot);
        if (obj.getType() == 2) {
            return (MfLogBrush)obj;
        }
        throw new IllegalStateException("Object " + slot + " was no brush");
    }

    public MfLogPen getPenObject(int slot) {
        WmfObject obj = this.getObject(slot);
        if (obj.getType() == 1) {
            return (MfLogPen)obj;
        }
        throw new IllegalStateException("Object " + slot + " was no pen");
    }

    public MfLogRegion getRegionObject(int slot) {
        WmfObject obj = this.getObject(slot);
        if (obj.getType() == 5) {
            return (MfLogRegion)obj;
        }
        throw new IllegalStateException("Object " + slot + " was no region");
    }

    public synchronized BufferedImage replay() {
        return this.replay(this.imageWidth, this.imageHeight);
    }

    public synchronized BufferedImage replay(int imageX, int imageY) {
        BufferedImage image = new BufferedImage(imageX, imageY, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(new Color(0, 0, 0, 0));
        graphics.fill(new Rectangle(0, 0, imageX, imageY));
        this.draw(graphics, new Rectangle2D.Float(0.0f, 0.0f, imageX, imageY));
        graphics.dispose();
        return image;
    }

    public synchronized void draw(Graphics2D graphics, Rectangle2D bounds) {
        this.scaleToFit((float)bounds.getWidth(), (float)bounds.getHeight());
        graphics.translate(bounds.getX(), bounds.getY());
        graphics.translate(-this.imageX, -this.imageY);
        this.graphics = graphics;
        for (int i = 0; i < this.records.size(); ++i) {
            try {
                MfCmd command = (MfCmd)this.records.get(i);
                command.setScale((float)this.imageWidth / (float)this.maxWidth, (float)this.imageHeight / (float)this.maxHeight);
                command.replay(this);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error while processing image record #" + i), (Throwable)e);
            }
        }
        this.resetStates();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public String toString() {
        StringBuilder bo = new StringBuilder(500);
        bo.append("WmfFile={width=");
        bo.append(this.imageWidth);
        bo.append(", height=");
        bo.append(this.imageHeight);
        bo.append(", recordCount=");
        bo.append(this.records.size());
        bo.append(", records={\n");
        for (int i = 0; i < this.records.size(); ++i) {
            MfCmd cmd = (MfCmd)this.records.get(i);
            bo.append(i);
            bo.append(',');
            bo.append(cmd.toString());
            bo.append('\n');
        }
        bo.append("}\n");
        return bo.toString();
    }
}

