/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.pixie.wmf.GDIColor;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogBrush;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdCreateBrush
extends MfCmd {
    private static final Log logger = LogFactory.getLog(MfCmdCreateBrush.class);
    private static final int PARAM_STYLE = 0;
    private static final int PARAM_COLOR = 1;
    private static final int PARAM_HATCH = 3;
    private static final int RECORD_SIZE = 4;
    private int style;
    private Color color;
    private int hatch;

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append("[CREATE_BRUSH] style=");
        b.append(this.getStyle());
        b.append(" color=");
        b.append(this.getColor());
        b.append(" hatch=");
        b.append(this.getHatch());
        return b.toString();
    }

    public void replay(WmfFile file) {
        MfLogBrush lbrush = new MfLogBrush();
        lbrush.setStyle(this.getStyle());
        lbrush.setColor(this.getColor());
        lbrush.setHatchedStyle(this.getHatch());
        file.getCurrentState().setLogBrush(lbrush);
        file.storeObject(lbrush);
    }

    public MfCmd getInstance() {
        return new MfCmdCreateBrush();
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public void setHatch(int hatch) {
        if (hatch != 5 && hatch != 8 && hatch != 6 && hatch != 2 && hatch != 1 && hatch != 4 && hatch != 9 && hatch != 3 && hatch != 7 && hatch != 0) {
            throw new IllegalArgumentException("The specified pattern is invalid");
        }
        this.hatch = hatch;
    }

    public int getHatch() {
        return this.hatch;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 764;
    }

    public void setRecord(MfRecord record) {
        if (record.getLength() != 14) {
            logger.warn((Object)"Unknown type of CreateBrushIndirect encountered.");
        }
        int style = record.getParam(0);
        int color = record.getLongParam(1);
        int hatch = record.getParam(3);
        this.setStyle(style);
        this.setColor(new GDIColor(color));
        this.setHatch(hatch);
    }

    public MfRecord getRecord() {
        MfRecord record = new MfRecord(4);
        record.setParam(0, this.getStyle());
        record.setLongParam(1, GDIColor.translateColor(this.getColor()));
        record.setParam(3, this.getHatch());
        return record;
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

