/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfLogFont;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public final class MfCmdCreateFont
extends MfCmd {
    public static final int CHARSET_ANSI = 0;
    public static final int CHARSET_DEFAULT = 1;
    public static final int CHARSET_SYMBOL = 2;
    public static final int CHARSET_SHIFTJIS = 128;
    public static final int CHARSET_OEM = 255;
    private static final int FONT_FACE_MAX = 31;
    private static final int FIXED_RECORD_SIZE = 9;
    private static final int POS_HEIGHT = 0;
    private static final int POS_WIDTH = 1;
    private static final int POS_ESCAPEMENT = 2;
    private static final int POS_ORIENTATION = 3;
    private static final int POS_WEIGHT = 4;
    private static final int POS_FLAGS1 = 5;
    private static final int POS_FLAGS2 = 6;
    private static final int POS_PRECISION = 7;
    private static final int POS_QUALITY = 8;
    private static final int POS_FONTFACE = 9;
    private int height;
    private int width;
    private int scaled_height;
    private int scaled_width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charset;
    private int outprecision;
    private int clipprecision;
    private int quality;
    private int pitchAndFamily;
    private String facename;

    public void replay(WmfFile file) {
        MfLogFont lfont = new MfLogFont();
        lfont.setFace(this.getFontFace());
        lfont.setSize(this.getScaledHeight());
        int style = this.getWeight() > 650 ? 1 : 0;
        if (this.isItalic()) {
            style += 2;
        }
        lfont.setStyle(style);
        lfont.setUnderline(this.isUnderline());
        lfont.setStrikeOut(this.isStrikeout());
        lfont.setRotation(this.getEscapement() / 10);
        file.getCurrentState().setLogFont(lfont);
        file.storeObject(lfont);
    }

    public MfCmd getInstance() {
        return new MfCmdCreateFont();
    }

    public MfRecord getRecord() {
        String fontFace = this.getFontFace();
        if (fontFace.length() > 31) {
            fontFace = fontFace.substring(0, 31);
        }
        MfRecord record = new MfRecord(9 + fontFace.length());
        record.setParam(0, this.getHeight());
        record.setParam(1, this.getWidth());
        record.setParam(2, this.getEscapement());
        record.setParam(3, this.getOrientation());
        record.setParam(4, this.getWeight());
        record.setParam(5, this.formFlags(this.isUnderline(), this.isItalic()));
        record.setParam(6, this.formFlags(this.isStrikeout(), false) + this.getCharset());
        record.setParam(7, this.getOutputPrecision() << 8 + this.getClipPrecision());
        record.setParam(8, this.getQuality() << 8 + this.getPitchAndFamily());
        record.setStringParam(9, fontFace);
        return record;
    }

    public void setRecord(MfRecord record) {
        int height = record.getParam(0);
        if (height == 0) {
            height = 10;
        }
        if (height < 0) {
            height *= -1;
        }
        int width = record.getParam(1);
        int escape = record.getParam(2);
        int orientation = record.getParam(3);
        int weight = record.getParam(4);
        int italic = record.getParam(5) & 0xFF;
        int underline = record.getParam(5) & 0xFF00;
        int strikeout = record.getParam(6) & 0xFF;
        int charset = record.getParam(6) & 0xFF00;
        int outprec = record.getParam(7) & 0xFF;
        int clipprec = record.getParam(7) & 0xFF00;
        int quality = record.getParam(8) & 0xFF;
        int pitch = record.getParam(8) & 0xFF00;
        String facename = record.getStringParam(9, 32);
        this.setCharset(charset);
        this.setClipPrecision(clipprec);
        this.setEscapement(escape);
        this.setFontFace(facename);
        this.setHeight(height);
        this.setItalic(italic != 0);
        this.setOrientation(orientation);
        this.setOutputPrecision(outprec);
        this.setPitchAndFamily(pitch);
        this.setQuality(quality);
        this.setStrikeout(strikeout != 0);
        this.setUnderline(underline != 0);
        this.setWeight(weight);
        this.setWidth(width);
    }

    private int formFlags(boolean f1, boolean f2) {
        int retval = 0;
        if (f1) {
            retval += 256;
        }
        if (f2) {
            ++retval;
        }
        return retval;
    }

    public int getFunction() {
        return 763;
    }

    public void setFontFace(String facename) {
        this.facename = facename;
    }

    public String getFontFace() {
        return this.facename;
    }

    public void setPitchAndFamily(int pitchAndFamily) {
        this.pitchAndFamily = pitchAndFamily;
    }

    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setClipPrecision(int clipprecision) {
        this.clipprecision = clipprecision;
    }

    public int getClipPrecision() {
        return this.clipprecision;
    }

    public void setOutputPrecision(int outprecision) {
        this.outprecision = outprecision;
    }

    public int getOutputPrecision() {
        return this.outprecision;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setHeight(int height) {
        this.height = height;
        this.scaleYChanged();
    }

    public int getHeight() {
        return this.height;
    }

    public int getScaledHeight() {
        return this.scaled_height;
    }

    public void setWidth(int width) {
        this.width = width;
        this.scaleXChanged();
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getScaledWidth() {
        return this.scaled_width;
    }

    public void setEscapement(int escapement) {
        this.escapement = escapement;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setUnderline(boolean ul) {
        this.underline = ul;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setStrikeout(boolean so) {
        this.strikeout = so;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[CREATE_FONT] face=");
        b.append(this.getFontFace());
        b.append(" height=");
        b.append(this.getHeight());
        b.append(" width=");
        b.append(this.getWidth());
        b.append(" weight=");
        b.append(this.getWeight());
        b.append(" italic=");
        b.append(this.isItalic());
        b.append(" Strikeout=");
        b.append(this.isStrikeout());
        b.append(" Underline=");
        b.append(this.isUnderline());
        b.append(" outprecision=");
        b.append(this.getOutputPrecision());
        b.append(" escapement=");
        b.append(this.getEscapement());
        return b.toString();
    }
}

