/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import java.awt.Point;
import org.pentaho.reporting.libraries.pixie.wmf.GDIColor;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdExtFloodFill
extends MfCmd {
    public static final int FLOODFILLBORDER = 0;
    public static final int FLOODFILLSURFACE = 1;
    private int filltype;
    private Color color;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private static final int RECORD_SIZE = 5;
    private static final int POS_FILLTYPE = 0;
    private static final int POS_COLOR = 1;
    private static final int POS_Y = 3;
    private static final int POS_X = 4;

    public void replay(WmfFile file) {
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[EXT_FLOOD_FILL] filltype=");
        b.append(this.getFillType());
        b.append(" color=");
        b.append(this.getColor());
        b.append(" target=");
        b.append(this.getTarget());
        return b.toString();
    }

    public MfCmd getInstance() {
        return new MfCmdExtFloodFill();
    }

    public void setRecord(MfRecord record) {
        int filltype = record.getParam(0);
        int c = record.getLongParam(1);
        GDIColor color = new GDIColor(c);
        int y = record.getParam(3);
        int x = record.getParam(4);
        this.setTarget(x, y);
        this.setColor(color);
        this.setFillType(filltype);
    }

    public MfRecord getRecord() {
        MfRecord record = new MfRecord(5);
        record.setParam(0, this.getFillType());
        record.setLongParam(1, GDIColor.translateColor(this.getColor()));
        Point target = this.getTarget();
        record.setParam(3, (int)target.getY());
        record.setParam(4, (int)target.getX());
        return record;
    }

    public void setFillType(int filltype) {
        this.filltype = filltype;
    }

    public int getFillType() {
        return this.filltype;
    }

    public int getFunction() {
        return 1352;
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public void setTarget(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

