/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogFont;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdExtTextOut
extends MfCmd {
    private static final int POS_Y = 0;
    private static final int POS_X = 1;
    private static final int POS_CHAR_COUNT = 2;
    private static final int POS_FLAGS = 3;
    private static final int POS_CLIP_X = 4;
    private static final int POS_CLIP_Y = 5;
    private static final int POS_CLIP_W = 6;
    private static final int POS_CLIP_H = 7;
    private static final int RECORD_BASE_SIZE_CLIPPED = 8;
    private static final int RECORD_BASE_SIZE_STANDARD = 4;
    public static final int ETO_OPAQUE = 2;
    public static final int ETO_CLIPPED = 4;
    public static final int ETO_GLYPH_INDEX = 16;
    public static final int ETO_RTLREADING = 128;
    public static final int ETO_IGNORELANGUAGE = 4096;
    private int flags;
    private int x;
    private int y;
    private int cx;
    private int cy;
    private int cw;
    private int ch;
    private int scaled_x;
    private int scaled_y;
    private int scaled_cx;
    private int scaled_cy;
    private int scaled_cw;
    private int scaled_ch;
    private String text;

    public void replay(WmfFile file) {
        Graphics2D graphics = file.getGraphics2D();
        MfDcState state = file.getCurrentState();
        MfLogFont lFont = state.getLogFont();
        state.prepareDrawText();
        FontMetrics metrics = graphics.getFontMetrics();
        int textWidth = metrics.stringWidth(this.text);
        Point p = this.getScaledOrigin();
        int x = p.x + this.calcDeltaX(state.getVerticalTextAlignment(), textWidth);
        int y = p.y + this.calcDeltaY(state.getHorizontalTextAlignment(), metrics);
        if (this.isOpaque() || state.getBkMode() != 1) {
            Rectangle background = new Rectangle(x, y - metrics.getAscent(), textWidth, metrics.getHeight());
            graphics.setColor(state.getBkColor());
            graphics.fill(background);
            graphics.setColor(state.getTextColor());
        }
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.drawString(this.text, x, y);
        if (lFont.isUnderline()) {
            g2.setStroke(new BasicStroke(metrics.getHeight() / 14));
            g2.drawLine(x, y += metrics.getDescent() / 8 + 1, x + textWidth, y);
        }
        if (lFont.isStrikeOut()) {
            y = (int)((double)y - ((double)metrics.getAscent() / 2.5 + 1.0));
            g2.setStroke(new BasicStroke(metrics.getHeight() / 14));
            g2.drawLine(x, y, x + textWidth, y);
        }
        state.postDrawText();
    }

    protected int calcDeltaX(int valign, int textWidth) {
        if (valign == 0) {
            return 0;
        }
        if (valign == 6) {
            return textWidth / -2;
        }
        return textWidth * -1;
    }

    protected int calcDeltaY(int halign, FontMetrics fm) {
        if (halign == 0) {
            return fm.getAscent();
        }
        if (halign == 8) {
            return fm.getDescent();
        }
        return 0;
    }

    public MfCmd getInstance() {
        return new MfCmdExtTextOut();
    }

    public int getFunction() {
        return 2610;
    }

    public void setRecord(MfRecord record) {
        int stringOffset;
        int y = record.getParam(0);
        int x = record.getParam(1);
        int count = record.getParam(2);
        int flag = record.getParam(3);
        int cx = 0;
        int cy = 0;
        int cw = 0;
        int ch = 0;
        if ((flag & 4) == 4) {
            cx = record.getParam(4);
            cy = record.getParam(5);
            cw = record.getParam(6);
            ch = record.getParam(7);
            stringOffset = 8;
        } else {
            stringOffset = 4;
        }
        String text = record.getStringParam(stringOffset, count);
        this.setOrigin(x, y);
        this.setText(text);
        this.setClippingRect(cx, cy, cw, ch);
        this.setFlags(flag);
    }

    public MfRecord getRecord() {
        String text = this.getText();
        int flag = this.getFlags();
        int parcnt = (flag & 4) == 4 ? 8 : 4;
        int recordLength = (int)(Math.ceil(text.length() / 2) * 2.0) + parcnt;
        MfRecord record = new MfRecord(recordLength);
        Point origin = this.getOrigin();
        record.setParam(0, (int)origin.getY());
        record.setParam(1, (int)origin.getX());
        record.setParam(2, text.length());
        record.setParam(3, flag);
        if ((flag & 4) == 4) {
            Rectangle rect = this.getClippingRect();
            record.setParam(4, rect.x);
            record.setParam(5, rect.y);
            record.setParam(6, rect.width);
            record.setParam(7, rect.height);
        }
        record.setStringParam(parcnt, text);
        return record;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[EXT_TEXT_OUT] text=");
        b.append(this.getText());
        b.append(" origin=");
        b.append(this.getOrigin());
        b.append(" clippingRect=");
        b.append(this.getClippingRect());
        b.append(" flags=");
        b.append(this.getFlags());
        return b.toString();
    }

    public void setOrigin(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public Point getScaledOrigin() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public boolean isClipped() {
        return (this.flags & 4) == 4;
    }

    public boolean isOpaque() {
        return (this.flags & 2) == 2;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setClippingRect(int cx, int cy, int cw, int ch) {
        this.cx = cx;
        this.cy = cy;
        this.cw = cw;
        this.ch = ch;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Rectangle getClippingRect() {
        return new Rectangle(this.cx, this.cy, this.cw, this.ch);
    }

    public Rectangle getScaledClippingRect() {
        return new Rectangle(this.scaled_cx, this.scaled_cy, this.scaled_cw, this.scaled_ch);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_cx = this.getScaledX(this.cx);
        this.scaled_cw = this.getScaledX(this.cw);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_cy = this.getScaledY(this.cy);
        this.scaled_ch = this.getScaledY(this.ch);
    }
}

