/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogBrush;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdFrameRegion
extends MfCmd {
    private int width;
    private int height;
    private int scaled_width;
    private int scaled_height;
    private int brushObjectNr;
    private int regionObjectNr;

    public void replay(WmfFile file) {
        MfLogBrush brush = file.getBrushObject(this.brushObjectNr);
        MfLogRegion regio = file.getRegionObject(this.regionObjectNr);
        MfDcState state = file.getCurrentState();
        state.setLogRegion(regio);
        state.setLogBrush(brush);
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.scaleRect(regio.getBounds());
        if (brush.isVisible()) {
            Dimension dim = this.getScaledDimension();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrame(rec.x, rec.y, rec.width, dim.height);
            state.preparePaint();
            graph.fill(rect);
            rect.setFrame(rec.x, rec.y - dim.height, rec.width, dim.height);
            graph.fill(rect);
            rect.setFrame(rec.x, rec.y, dim.width, rec.height);
            graph.fill(rect);
            rect.setFrame(rec.width - dim.width, rec.y, dim.width, rec.height);
            graph.fill(rect);
            state.postPaint();
        }
    }

    public MfCmd getInstance() {
        return new MfCmdFrameRegion();
    }

    public int getFunction() {
        return 1065;
    }

    public void setRecord(MfRecord record) {
        int height = record.getParam(0);
        int width = record.getParam(1);
        int regio = record.getParam(2);
        int brush = record.getParam(3);
        this.setBrush(brush);
        this.setRegion(regio);
        this.setDimension(width, height);
    }

    public MfRecord getRecord() {
        MfRecord record = new MfRecord(4);
        Dimension dim = this.getDimension();
        record.setParam(0, dim.height);
        record.setParam(1, dim.width);
        record.setParam(2, this.getRegion());
        record.setParam(3, this.getBrush());
        return record;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[FRAME_REGION] region=");
        b.append(this.getRegion());
        b.append(" brush=");
        b.append(this.getBrush());
        b.append(" dimension=");
        b.append(this.getDimension());
        return b.toString();
    }

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDimension(Dimension dim) {
        this.setDimension(dim.width, dim.height);
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getScaledDimension() {
        return new Dimension(this.scaled_width, this.scaled_height);
    }

    public int getBrush() {
        return this.brushObjectNr;
    }

    public void setBrush(int brush) {
        this.brushObjectNr = brush;
    }

    public int getRegion() {
        return this.regionObjectNr;
    }

    public void setRegion(int region) {
        this.regionObjectNr = region;
    }
}

