/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Point;
import java.awt.Rectangle;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdOffsetClipRgn
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Rectangle clipRect = state.getClipRegion();
        Point p = this.getScaledDestination();
        clipRect.x += p.x;
        clipRect.y += p.y;
        state.setClipRegion(clipRect);
    }

    public MfCmd getInstance() {
        return new MfCmdOffsetClipRgn();
    }

    public Point getDestination() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[OFFSET_CLIP_RECT] destination=");
        b.append(this.getDestination());
        return b.toString();
    }

    public void setDestination(Point p) {
        this.setDestination(p.x, p.y);
    }

    public void setDestination(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public int getFunction() {
        return 544;
    }

    public void setRecord(MfRecord record) {
        int y = record.getParam(0);
        int x = record.getParam(1);
        this.setDestination(x, y);
    }

    public MfRecord getRecord() {
        Point dest = this.getDestination();
        MfRecord record = new MfRecord(2);
        record.setParam(0, dest.y);
        record.setParam(1, dest.x);
        return record;
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

