/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdPolyline
extends MfCmd {
    private int[] points_x;
    private int[] points_y;
    private int[] scaled_points_x;
    private int[] scaled_points_y;
    private int count;

    public void replay(WmfFile file) {
        Graphics2D graph = file.getGraphics2D();
        MfDcState state = file.getCurrentState();
        int cx = state.getCurPosX();
        int cy = state.getCurPosY();
        int[] points_x = this.getScaledPointsX();
        int[] points_y = this.getScaledPointsY();
        if (state.getLogPen().isVisible()) {
            state.prepareDraw();
            cx = points_x[0];
            cy = points_y[0];
            Line2D.Double line = new Line2D.Double();
            for (int i = 1; i < this.count; ++i) {
                int destX = points_x[i];
                int destY = points_y[i];
                line.setLine(cx, cy, destX, destY);
                graph.draw(line);
                cx = destX;
                cy = destY;
            }
            state.postDraw();
        }
        state.setCurPos(cx, cy);
    }

    public MfCmd getInstance() {
        return new MfCmdPolyline();
    }

    public int getFunction() {
        return 805;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[POLYLINE] count=");
        b.append(this.getPointCount());
        int l = this.getPointCount();
        int[] points_x = this.getPointsX();
        int[] points_y = this.getPointsY();
        for (int i = 0; i < l; ++i) {
            if (i != 0) {
                b.append(',');
            }
            b.append(" (");
            b.append(points_x[i]);
            b.append(',');
            b.append(points_y[i]);
            b.append(") ");
        }
        return b.toString();
    }

    public void setRecord(MfRecord record) {
        int count = record.getParam(0);
        int[] points_x = new int[count];
        int[] points_y = new int[count];
        for (int i = 0; i < count; ++i) {
            points_x[i] = record.getParam(1 + 2 * i);
            points_y[i] = record.getParam(2 + 2 * i);
        }
        this.setPointCount(count);
        this.setPoints(points_x, points_y);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(this.getPointCount() * 2 + 1);
        int count = this.getPointCount();
        int[] points_x = this.getPointsX();
        int[] points_y = this.getPointsY();
        record.setParam(0, count);
        for (int i = 0; i < count; ++i) {
            record.setParam(1 + 2 * i, points_x[i]);
            record.setParam(2 + 2 * i, points_y[i]);
        }
        return record;
    }

    public void setPointCount(int count) {
        this.count = count;
    }

    public void setPoints(int[] points_x, int[] points_y) {
        this.points_x = points_x;
        this.points_y = points_y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public int[] getPointsX() {
        return this.points_x;
    }

    public int[] getPointsY() {
        return this.points_y;
    }

    public int getPointCount() {
        return this.count;
    }

    public int[] getScaledPointsX() {
        return this.scaled_points_x;
    }

    public int[] getScaledPointsY() {
        return this.scaled_points_y;
    }

    protected void scaleXChanged() {
        this.scaled_points_x = this.applyScaleX(this.points_x, this.scaled_points_x);
    }

    protected void scaleYChanged() {
        this.scaled_points_y = this.applyScaleY(this.points_y, this.scaled_points_y);
    }
}

