/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdRestoreDc
extends MfCmd {
    private int dcId;

    public void replay(WmfFile file) {
        if (this.dcId == 0) {
            return;
        }
        if (this.dcId > 0) {
            file.restoreDCState(this.dcId);
        } else {
            file.restoreDCState(file.getStateCount() - this.dcId);
        }
    }

    public MfCmd getInstance() {
        return new MfCmdRestoreDc();
    }

    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setNSavedDC(id);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getNSavedDC());
        return record;
    }

    public int getFunction() {
        return 295;
    }

    public int getNSavedDC() {
        return this.dcId;
    }

    public void setNSavedDC(int id) {
        this.dcId = id;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[RESTORE_DC] nSavedDC=");
        b.append(this.getNSavedDC());
        return b.toString();
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

