/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfLogBrush;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogFont;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogPalette;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogPen;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.WmfObject;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSelectObject
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_OBJECT_ID = 0;
    private int objectId;

    public void replay(WmfFile file) {
        WmfObject object = file.getObject(this.objectId);
        if (object == null) {
            throw new NullPointerException("Object " + this.objectId + " is not defined");
        }
        switch (object.getType()) {
            case 2: {
                file.getCurrentState().setLogBrush((MfLogBrush)object);
                break;
            }
            case 4: {
                file.getCurrentState().setLogFont((MfLogFont)object);
                break;
            }
            case 3: {
                file.getCurrentState().setLogPalette((MfLogPalette)object);
                break;
            }
            case 1: {
                file.getCurrentState().setLogPen((MfLogPen)object);
                break;
            }
            case 5: {
                file.getCurrentState().setLogRegion((MfLogRegion)object);
            }
        }
    }

    public MfCmd getInstance() {
        return new MfCmdSelectObject();
    }

    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setObjectId(id);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getObjectId());
        return record;
    }

    public int getFunction() {
        return 301;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int id) {
        this.objectId = id;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[SELECT_OBJECT] object=");
        b.append(this.getObjectId());
        return b.toString();
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

