/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.pentaho.reporting.libraries.pixie.wmf.GDIColor;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetPixel
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_COLOR = 0;
    private static final int POS_X = 3;
    private static final int POS_Y = 2;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private Color color;

    public void replay(WmfFile file) {
        Point p = this.getScaledTarget();
        Graphics2D g = file.getGraphics2D();
        MfDcState state = file.getCurrentState();
        state.prepareDraw();
        g.drawLine(p.x, p.y, p.x, p.y);
        state.postDraw();
    }

    public MfCmd getInstance() {
        return new MfCmdSetPixel();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(4);
        record.setLongParam(0, GDIColor.translateColor(this.getColor()));
        Point p = this.getTarget();
        record.setParam(3, p.x);
        record.setParam(2, p.y);
        return record;
    }

    public void setRecord(MfRecord record) {
        int c = record.getLongParam(0);
        GDIColor color = new GDIColor(c);
        int y = record.getParam(2);
        int x = record.getParam(3);
        this.setTarget(x, y);
        this.setColor(color);
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public void setTarget(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setTarget(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 1055;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[SET_PIXEL] target=");
        b.append(this.getTarget());
        b.append(" color=");
        b.append(this.getColor());
        return b.toString();
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

