/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetPolyFillMode
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_POLYFILLMODE = 0;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    private int fillmode;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setPolyFillMode(this.fillmode);
    }

    public MfCmd getInstance() {
        return new MfCmdSetPolyFillMode();
    }

    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setFillMode(id);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getFillMode());
        return record;
    }

    public int getFunction() {
        return 262;
    }

    public int getFillMode() {
        return this.fillmode;
    }

    public void setFillMode(int id) {
        this.fillmode = id;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[SET_POLY_FILL_MODE] fillmode=");
        b.append(this.getFillMode());
        return b.toString();
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

