/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Dimension;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetViewPortExt
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_HEIGHT = 0;
    private static final int POS_WIDTH = 1;
    private int height;
    private int width;
    private int scaled_width;
    private int scaled_height;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Dimension dim = this.getScaledDimension();
        state.setViewportExt(dim.width, dim.height);
    }

    public MfCmd getInstance() {
        return new MfCmdSetViewPortExt();
    }

    public void setRecord(MfRecord record) {
        int height = record.getParam(0);
        int width = record.getParam(1);
        this.setDimension(width, height);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        Dimension dim = this.getDimension();
        record.setParam(0, dim.height);
        record.setParam(1, dim.width);
        return record;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[SET_VIEWPORT_EXT] dimension=");
        b.append(this.getDimension());
        return b.toString();
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getScaledDimension() {
        return new Dimension(this.scaled_width, this.scaled_height);
    }

    public void setDimension(int w, int h) {
        this.width = w;
        this.height = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public int getFunction() {
        return 526;
    }
}

