/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.SchemaResolver;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultCubeFileProvider
implements CubeFileProvider {
    private String mondrianCubeFile;

    public DefaultCubeFileProvider() {
    }

    public DefaultCubeFileProvider(String mondrianCubeFile) {
        this.mondrianCubeFile = mondrianCubeFile;
    }

    public String getDesignTimeFile() {
        return this.mondrianCubeFile;
    }

    public String getMondrianCubeFile() {
        return this.mondrianCubeFile;
    }

    public void setMondrianCubeFile(String mondrianCubeFile) {
        this.mondrianCubeFile = mondrianCubeFile;
    }

    public String getCubeFile(ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException {
        if (this.mondrianCubeFile == null) {
            throw new ReportDataFactoryException("No schema file defined.");
        }
        File cubeAsFile = new File(this.mondrianCubeFile);
        if (cubeAsFile.isFile()) {
            return this.mondrianCubeFile;
        }
        try {
            return SchemaResolver.resolveSchema(resourceManager, contextKey, this.mondrianCubeFile);
        }
        catch (FileSystemException e) {
            return this.mondrianCubeFile;
        }
    }

    public Object getConnectionHash() {
        ArrayList<String> hash = new ArrayList<String>();
        hash.add(this.getClass().getName());
        hash.add(this.getMondrianCubeFile());
        return hash;
    }
}

