/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianConnectionProvider;

public class DefaultMondrianConnectionProvider
implements MondrianConnectionProvider {
    protected String computeConnectionString(Properties parameters) {
        StringBuilder connectionStr = new StringBuilder(100);
        connectionStr.append("provider=mondrian");
        connectionStr.append("; ");
        connectionStr.append("Catalog=");
        connectionStr.append(parameters.getProperty("Catalog"));
        Enumeration<Object> objectEnumeration = parameters.keys();
        while (objectEnumeration.hasMoreElements()) {
            String value;
            String key = (String)objectEnumeration.nextElement();
            if ("Catalog".equals(key) || (value = parameters.getProperty(key)) == null) continue;
            connectionStr.append("; ");
            connectionStr.append(key);
            connectionStr.append("=");
            connectionStr.append((Object)value);
        }
        return connectionStr.toString();
    }

    public Connection createConnection(Properties properties, DataSource dataSource) throws ReportDataFactoryException {
        return DriverManager.getConnection((Util.PropertyList)Util.parseConnectString((String)this.computeConnectionString(properties)), null, (DataSource)dataSource);
    }

    public Object getConnectionHash(Properties properties) throws ReportDataFactoryException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        list.add(properties.clone());
        return list;
    }
}

