/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataCellAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataMemberAttributes;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class DenormalizedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private static final Log logger = LogFactory.getLog(DenormalizedMDXTableModel.class);
    private boolean noMeasures;
    private Result resultSet;
    private int rowCount;
    private int columnCount;
    private String[] columnNames;
    private int[] axesSize;
    private int[] columnToAxisPosition;
    private Dimension[] columnToDimensionMapping;

    public DenormalizedMDXTableModel(Result resultSet) {
        int i;
        if (resultSet == null) {
            throw new NullPointerException("ResultSet returned was null");
        }
        this.resultSet = resultSet;
        Axis[] axes = this.resultSet.getAxes();
        this.rowCount = 0;
        this.axesSize = new int[axes.length];
        int[] axesMembers = new int[axes.length];
        List[] dimensionsForMembersPerAxis = new List[axes.length];
        List[] membersPerAxis = new List[axes.length];
        for (int axesIndex = axes.length - 1; axesIndex >= 0; --axesIndex) {
            Axis axis = axes[axesIndex];
            List positions = axis.getPositions();
            this.axesSize[axesIndex] = positions.size();
            if (positions.isEmpty()) {
                this.noMeasures = true;
            }
            ArrayList<Integer> memberList = new ArrayList<Integer>();
            ArrayList<Dimension> dimensionsForMembers = new ArrayList<Dimension>();
            for (int positionsIndex = 0; positionsIndex < positions.size(); ++positionsIndex) {
                Position position = (Position)positions.get(positionsIndex);
                for (int positionIndex = 0; positionIndex < position.size(); ++positionIndex) {
                    Member m;
                    LinkedHashSet<String> columnNamesSet = new LinkedHashSet<String>();
                    Dimension dimension = m.getDimension();
                    int hierarchyLevelCount = 0;
                    for (m = (Member)position.get(positionIndex); m != null; m = m.getParentMember()) {
                        String name = m.getLevel().getUniqueName();
                        if (columnNamesSet.contains(name)) continue;
                        columnNamesSet.add(name);
                    }
                    hierarchyLevelCount = columnNamesSet.size();
                    if (memberList.size() <= positionIndex) {
                        memberList.add(hierarchyLevelCount);
                        dimensionsForMembers.add(dimension);
                        continue;
                    }
                    Integer existingLevel = (Integer)memberList.get(positionIndex);
                    if (existingLevel >= hierarchyLevelCount) continue;
                    memberList.set(positionIndex, hierarchyLevelCount);
                    dimensionsForMembers.set(positionIndex, dimension);
                }
            }
            int memberCount = 0;
            for (int i2 = 0; i2 < memberList.size(); ++i2) {
                memberCount += ((Integer)memberList.get(i2)).intValue();
            }
            axesMembers[axesIndex] = memberCount;
            dimensionsForMembersPerAxis[axesIndex] = dimensionsForMembers;
            membersPerAxis[axesIndex] = memberList;
        }
        if (this.axesSize.length > 0) {
            this.rowCount = this.axesSize[0];
            for (i = 1; i < this.axesSize.length; ++i) {
                int size = this.axesSize[i];
                this.rowCount *= size;
            }
        }
        this.rowCount = Math.max(1, this.rowCount);
        for (i = 0; i < axesMembers.length; ++i) {
            this.columnCount += axesMembers[i];
        }
        if (!this.noMeasures) {
            ++this.columnCount;
        }
        this.columnNames = new String[this.columnCount];
        this.columnToDimensionMapping = new Dimension[this.columnCount];
        this.columnToAxisPosition = new int[this.columnCount];
        int columnIndex = 0;
        int dimColIndex = 0;
        FastStack memberStack = new FastStack();
        for (int axesIndex = axes.length - 1; axesIndex >= 0; --axesIndex) {
            Axis axis = axes[axesIndex];
            List positions = axis.getPositions();
            LinkedHashSet<String> columnNamesSet = new LinkedHashSet<String>();
            for (int positionsIndex = 0; positionsIndex < positions.size(); ++positionsIndex) {
                Position position = (Position)positions.get(positionsIndex);
                for (int positionIndex = 0; positionIndex < position.size(); ++positionIndex) {
                    Member m;
                    memberStack.clear();
                    for (m = (Member)position.get(positionIndex); m != null; m = m.getParentMember()) {
                        memberStack.push((Object)m);
                    }
                    while (!memberStack.isEmpty()) {
                        m = (Member)memberStack.pop();
                        String name = m.getLevel().getUniqueName();
                        if (columnNamesSet.contains(name)) continue;
                        columnNamesSet.add(name);
                    }
                }
            }
            if (columnNamesSet.size() != axesMembers[axesIndex]) {
                logger.error((Object)"ERROR: Number of names is not equal the pre-counted number.");
            }
            List dimForMemberPerAxis = dimensionsForMembersPerAxis[axesIndex];
            List memberCntPerAxis = membersPerAxis[axesIndex];
            for (int i3 = 0; i3 < memberCntPerAxis.size(); ++i3) {
                Integer count = (Integer)memberCntPerAxis.get(i3);
                Dimension dim = (Dimension)dimForMemberPerAxis.get(i3);
                for (int x = 0; x < count; ++x) {
                    this.columnToDimensionMapping[dimColIndex + x] = dim;
                    this.columnToAxisPosition[dimColIndex + x] = axesIndex;
                }
                dimColIndex = count + dimColIndex;
            }
            String[] names = columnNamesSet.toArray(new String[columnNamesSet.size()]);
            System.arraycopy(names, 0, this.columnNames, columnIndex, names.length);
            columnIndex += names.length;
        }
        if (!this.noMeasures) {
            Member measureName = this.computeMeasureName(resultSet);
            this.columnNames[columnIndex] = measureName != null ? measureName.getUniqueName() : "Measure";
        }
    }

    private Member computeMeasureName(Result resultSet) {
        List positionList = resultSet.getSlicerAxis().getPositions();
        for (int i = 0; i < positionList.size(); ++i) {
            Position position = (Position)positionList.get(i);
            for (int positionIndex = 0; positionIndex < position.size(); ++positionIndex) {
                for (Member m = (Member)position.get(positionIndex); m != null; m = m.getParentMember()) {
                    if (!m.isMeasure()) continue;
                    return m;
                }
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String name;
        if (columnIndex >= this.columnNames.length) {
            throw new IndexOutOfBoundsException();
        }
        int[] cellKey = this.getCellKey(rowIndex);
        Dimension dimension = this.columnToDimensionMapping[columnIndex];
        if (dimension == null) {
            Cell cell = this.resultSet.getCell(cellKey);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        Member contextMember = this.getContextMember(dimension, columnIndex, cellKey);
        String string = name = contextMember.getParentMember() == null ? contextMember.getName() : null;
        while (contextMember != null) {
            if (contextMember.getLevel().getUniqueName().equals(this.getColumnName(columnIndex))) {
                return contextMember.getName();
            }
            contextMember = contextMember.getParentMember();
        }
        return name;
    }

    private Member getContextMember(Dimension dimension, int columnIndex, int[] cellKey) {
        int axisIndex = this.columnToAxisPosition[columnIndex];
        Axis[] axes = this.resultSet.getAxes();
        Axis axis = axes[axisIndex];
        Integer posIndex = cellKey[axisIndex];
        List positionList = axis.getPositions();
        if (positionList.isEmpty()) {
            return null;
        }
        Position position = (Position)positionList.get(posIndex);
        for (int i = 0; i < position.size(); ++i) {
            Member member = (Member)position.get(i);
            if (!dimension.equals(member.getDimension())) continue;
            return member;
        }
        return null;
    }

    public void close() {
        this.resultSet.close();
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnNames.length) {
            throw new IndexOutOfBoundsException();
        }
        int[] cellKey = this.getCellKey(rowIndex);
        Dimension dimension = this.columnToDimensionMapping[columnIndex];
        if (dimension == null) {
            Cell cell = this.resultSet.getCell(cellKey);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        for (Member contextMember = this.getContextMember(dimension, columnIndex, cellKey); contextMember != null; contextMember = contextMember.getParentMember()) {
            if (!contextMember.getLevel().getUniqueName().equals(this.getColumnName(columnIndex))) continue;
            return new MDXMetaDataMemberAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, contextMember);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    private int[] getCellKey(int rowIndex) {
        int[] cellKey = new int[this.axesSize.length];
        int tmpRowIdx = rowIndex;
        for (int i = 0; i < this.axesSize.length; ++i) {
            int pos;
            int axisSize = this.axesSize[i];
            if (axisSize == 0) {
                cellKey[i] = 0;
                continue;
            }
            cellKey[i] = pos = tmpRowIdx % axisSize;
            tmpRowIdx /= axisSize;
        }
        return cellKey;
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        DefaultDataAttributes dataAttributes = new DefaultDataAttributes();
        dataAttributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", DefaultConceptQueryMapper.INSTANCE, (Object)"normalized");
        return dataAttributes;
    }
}

