/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class DriverDataSourceCache {
    private static LFUMap<DriverConnectionKey, DriverManagerDataSource> cache;

    private DriverDataSourceCache() {
    }

    public static synchronized DataSource createDataSource(String jdbcUrl, Properties properties) {
        DriverConnectionKey key;
        Object o;
        if (cache == null) {
            cache = new LFUMap(20);
        }
        if ((o = cache.get((Object)(key = new DriverConnectionKey(jdbcUrl, properties)))) instanceof DataSource) {
            return (DataSource)o;
        }
        DriverManagerDataSource managerDataSource = new DriverManagerDataSource(jdbcUrl, properties);
        cache.put((Object)key, (Object)managerDataSource);
        return managerDataSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DriverManagerDataSource
    implements DataSource {
        private String jdbcConnectString;
        private PrintWriter logWriter;
        private int loginTimeout;
        private Properties jdbcProperties;

        public DriverManagerDataSource(String jdbcConnectString, Properties properties) {
            if (jdbcConnectString == null) {
                throw new NullPointerException();
            }
            if (properties == null) {
                throw new NullPointerException();
            }
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = (Properties)properties.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DriverManagerDataSource that = (DriverManagerDataSource)o;
            if (this.loginTimeout != that.loginTimeout) {
                return false;
            }
            if (!this.jdbcConnectString.equals(that.jdbcConnectString)) {
                return false;
            }
            if (!this.jdbcProperties.equals(that.jdbcProperties)) {
                return false;
            }
            return !(this.logWriter != null ? !this.logWriter.equals(that.logWriter) : that.logWriter != null);
        }

        public int hashCode() {
            int result = this.jdbcConnectString.hashCode();
            result = 31 * result + (this.logWriter != null ? this.logWriter.hashCode() : 0);
            result = 31 * result + this.loginTimeout;
            result = 31 * result + this.jdbcProperties.hashCode();
            return result;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(this.jdbcConnectString, this.jdbcProperties);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            Properties temp = (Properties)this.jdbcProperties.clone();
            if (username != null) {
                temp.put("user", username);
            }
            if (password != null) {
                temp.put("password", password);
            }
            return DriverManager.getConnection(this.jdbcConnectString, temp);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.logWriter;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.logWriter = out;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.loginTimeout = seconds;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.loginTimeout;
        }

        public boolean isWrapperFor(Class c) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> c) throws SQLException {
            throw new SQLException("This class cannot be unwrapped.");
        }
    }

    private static class DriverConnectionKey
    implements Serializable {
        private String jdbcConnectString;
        private Properties jdbcProperties;

        private DriverConnectionKey(String jdbcConnectString, Properties jdbcProperties) {
            if (jdbcConnectString == null) {
                throw new NullPointerException();
            }
            if (jdbcProperties == null) {
                throw new NullPointerException();
            }
            this.jdbcConnectString = jdbcConnectString;
            this.jdbcProperties = (Properties)jdbcProperties.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DriverConnectionKey that = (DriverConnectionKey)o;
            if (!this.jdbcConnectString.equals(that.jdbcConnectString)) {
                return false;
            }
            return this.jdbcProperties.equals(that.jdbcProperties);
        }

        public int hashCode() {
            int result = this.jdbcConnectString.hashCode();
            result = 31 * result + this.jdbcProperties.hashCode();
            return result;
        }
    }
}

