/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class JndiDataSourceProvider
implements DataSourceProvider {
    private String connectionPath;
    private static InitialContext initialContext;
    private static LFUMap cachedDataSources;

    protected static synchronized InitialContext getInitialContext() throws NamingException {
        if (initialContext == null) {
            initialContext = new InitialContext();
        }
        return initialContext;
    }

    public JndiDataSourceProvider(String connectionPath) {
        if (connectionPath == null) {
            throw new NullPointerException();
        }
        this.connectionPath = connectionPath;
    }

    public String getConnectionPath() {
        return this.connectionPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiDataSourceProvider that = (JndiDataSourceProvider)o;
        return !(this.connectionPath != null ? !this.connectionPath.equals(that.connectionPath) : that.connectionPath != null);
    }

    public int hashCode() {
        return this.connectionPath != null ? this.connectionPath.hashCode() : 0;
    }

    public DataSource getDataSource() throws SQLException {
        if (this.connectionPath == null) {
            throw new SQLException("JNDI DataSource is invalid; no connection path is defined.");
        }
        try {
            InitialContext ctx = JndiDataSourceProvider.getInitialContext();
            return this.findDataSource(ctx, this.connectionPath);
        }
        catch (NamingException ne) {
            throw new SQLException("Failed to access the JNDI system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource findDataSource(Context initialContext, String connectionPath) throws SQLException {
        boolean cacheEnabled;
        LFUMap map;
        Configuration config;
        block18: {
            DataSource o1;
            config = ClassicEngineBoot.getInstance().getGlobalConfig();
            map = JndiDataSourceProvider.getDataSourceCache();
            cacheEnabled = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CacheJndiDataSources"));
            if (cacheEnabled) {
                LFUMap lFUMap = map;
                synchronized (lFUMap) {
                    o1 = (DataSource)map.get((Object)connectionPath);
                    if (o1 != null) {
                        return o1;
                    }
                }
            }
            try {
                Object o = initialContext.lookup(connectionPath);
                if (!(o instanceof DataSource)) break block18;
                if (cacheEnabled) {
                    o1 = map;
                    synchronized (o1) {
                        map.put((Object)connectionPath, o);
                    }
                }
                return (DataSource)o;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        Iterator keys = config.findPropertyKeys("org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.jndi-prefix.");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String prefix = config.getConfigProperty(key);
            try {
                Object o = initialContext.lookup(prefix + connectionPath);
                if (!(o instanceof DataSource)) continue;
                if (cacheEnabled) {
                    LFUMap lFUMap = map;
                    synchronized (lFUMap) {
                        map.put((Object)connectionPath, o);
                    }
                }
                return (DataSource)o;
            }
            catch (NamingException e) {
            }
        }
        throw new SQLException("Failed to access the JNDI system");
    }

    public static synchronized LFUMap getDataSourceCache() {
        if (cachedDataSources == null) {
            cachedDataSources = new LFUMap(40);
        }
        return cachedDataSources;
    }

    public Object getConnectionHash() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getClass().getName());
        list.add(this.connectionPath);
        return list;
    }
}

