/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Result;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataCellAttributes;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyBandedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private static final int AXIS_COLUMN = 0;
    private static final int AXIS_ROW = 1;
    private Result resultSet;
    private GenericObjectTable rowHeaders;
    private GenericObjectTable columnHeaders;
    private String[] columnNames;
    private int columnCount;
    private int rowCount;
    private boolean emptyAxisCase;

    public LegacyBandedMDXTableModel(Result resultSet, int queryLimitValue) throws ReportDataFactoryException {
        this.resultSet = resultSet;
        Axis[] axes = resultSet.getAxes();
        int axisCount = axes.length;
        if (axisCount > 2) {
            throw new ReportDataFactoryException("Cannot handle results with more than two axes.");
        }
        this.rowHeaders = this.createRowHeaders();
        this.columnHeaders = this.createColumnHeaders();
        this.columnCount = this.rowHeaders.getRowCount() > 0 ? this.rowHeaders.getColumnCount() + this.columnHeaders.getColumnCount() : this.columnHeaders.getColumnCount();
        if (this.columnCount == 0) {
            this.columnCount = 1;
            this.emptyAxisCase = true;
            this.columnNames = new String[]{"Measure"};
            this.rowCount = 1;
        } else {
            this.columnNames = new String[this.columnCount];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = this.calcColumnName(i);
            }
            this.rowCount = axisCount == 2 ? this.rowHeaders.getRowCount() : Math.max(1, this.rowHeaders.getRowCount());
        }
        if (queryLimitValue > 0) {
            this.rowCount = Math.min(queryLimitValue, this.rowCount);
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public void close() {
        this.resultSet.close();
    }

    private String calcColumnName(int columnNumber) {
        if (columnNumber < this.rowHeaders.getColumnCount()) {
            return this.calcColumnNameFromRowHeader(columnNumber);
        }
        columnNumber -= this.rowHeaders.getColumnCount();
        StringBuilder buf = new StringBuilder(32);
        for (int i = 0; i < this.columnHeaders.getRowCount(); ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append(String.valueOf(this.columnHeaders.getObject(i, columnNumber)));
        }
        return buf.toString();
    }

    private String calcColumnNameFromRowHeader(int columnNumber) {
        Axis[] axes = this.resultSet.getAxes();
        Axis axis = axes[1];
        List positions = axis.getPositions();
        Position firstPosition = (Position)positions.get(0);
        if (columnNumber < firstPosition.size()) {
            Member member = (Member)firstPosition.get(columnNumber);
            return member.getHierarchy().getName();
        }
        Member member = (Member)firstPosition.get(firstPosition.size() - 1);
        return member.getHierarchy().getName() + '{' + columnNumber + '}';
    }

    private GenericObjectTable createColumnHeaders() {
        Axis[] axes = this.resultSet.getAxes();
        if (axes.length < 1) {
            return new GenericObjectTable();
        }
        Axis axis = axes[0];
        List positions = axis.getPositions();
        int colCount = positions.size();
        GenericObjectTable result = new GenericObjectTable(20, Math.max(1, colCount));
        for (int c = 0; c < colCount; ++c) {
            Position position = (Position)positions.get(c);
            Member member = null;
            int rowCount = position.size();
            for (int r = 0; r < rowCount; ++r) {
                member = (Member)position.get(r);
                if (member == null) continue;
                result.setObject(r, c, (Object)member.getName());
            }
            if (member == null) continue;
            result.setObject(rowCount, c, (Object)member.getHierarchy().getName());
        }
        return result;
    }

    private GenericObjectTable createRowHeaders() {
        Axis[] axes = this.resultSet.getAxes();
        if (axes.length < 2) {
            return new GenericObjectTable();
        }
        Axis axis = axes[1];
        List positions = axis.getPositions();
        int rowCount = positions.size();
        GenericObjectTable result = new GenericObjectTable(Math.max(1, rowCount), 5);
        for (int r = 0; r < rowCount; ++r) {
            Position position = (Position)positions.get(r);
            Member member = null;
            int colCount = position.size();
            for (int c = 0; c < colCount; ++c) {
                member = (Member)position.get(c);
                result.setObject(r, c, (Object)member.getName());
            }
            if (member == null) continue;
            result.setObject(r, colCount, (Object)member.getHierarchy().getName());
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.resultSet == null) {
            return null;
        }
        if (columnIndex < this.rowHeaders.getColumnCount()) {
            return this.rowHeaders.getObject(rowIndex, columnIndex);
        }
        if (this.emptyAxisCase) {
            Cell cell = this.resultSet.getCell(new int[0]);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        if (this.rowHeaders.getRowCount() == 0) {
            int[] key = new int[]{columnIndex};
            Cell cell = this.resultSet.getCell(key);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        int[] key = new int[]{columnIndex - this.rowHeaders.getColumnCount(), rowIndex};
        Cell cell = this.resultSet.getCell(key);
        if (cell.isNull()) {
            return null;
        }
        return cell.getValue();
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        if (this.resultSet == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        if (columnIndex < this.rowHeaders.getColumnCount()) {
            return EmptyDataAttributes.INSTANCE;
        }
        if (this.emptyAxisCase) {
            Cell cell = this.resultSet.getCell(new int[0]);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        if (this.rowHeaders.getRowCount() == 0) {
            int[] key = new int[]{columnIndex};
            Cell cell = this.resultSet.getCell(key);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        int[] key = new int[]{columnIndex - this.rowHeaders.getColumnCount(), rowIndex};
        Cell c = this.resultSet.getCell(key);
        return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, c);
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        return EmptyDataAttributes.INSTANCE;
    }
}

