/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;

public class MondrianDataFactoryCore
extends DefaultDataFactoryCore {
    private static final Log logger = LogFactory.getLog(MondrianDataFactoryCore.class);

    public String getDisplayConnectionName(DataFactoryMetaData metaData, DataFactory dataFactory) {
        AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)dataFactory;
        String designTimeName = mdxDataFactory.getDesignTimeName();
        CubeFileProvider cubeFileProvider = mdxDataFactory.getCubeFileProvider();
        if (designTimeName != null && cubeFileProvider != null) {
            return designTimeName + " " + cubeFileProvider.getDesignTimeFile();
        }
        if (designTimeName != null) {
            return designTimeName;
        }
        if (cubeFileProvider != null) {
            return cubeFileProvider.getDesignTimeFile();
        }
        return null;
    }

    public Object getQueryHash(DataFactoryMetaData dataFactoryMetaData, DataFactory dataFactory, String queryName, DataRow parameter) {
        try {
            AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)dataFactory;
            return mdxDataFactory.getQueryHash(queryName, parameter);
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)"Unable to create query hash", (Throwable)e);
            return null;
        }
    }

    public String[] getReferencedFields(DataFactoryMetaData metaData, DataFactory element, String query, DataRow parameter) {
        try {
            AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)element;
            return mdxDataFactory.getReferencedFields(query, parameter);
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)"Unable to collect referenced fields", (Throwable)e);
            return null;
        }
    }
}

