/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.QueryDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.QueryDefinitionsReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.AbstractMDXDataSourceReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractNamedMDXDataSourceReadHandler
extends AbstractMDXDataSourceReadHandler {
    private ArrayList<PropertyReadHandler> queries = new ArrayList();
    private QueryDefinitionsReadHandler queryDefinitionsReadHandler;
    private PropertyReadHandler globalScriptReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("query".equals(tagName)) {
            PropertyReadHandler queryReadHandler = new PropertyReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        if ("global-script".equals(tagName)) {
            this.globalScriptReadHandler = new PropertyReadHandler("language", true);
            return this.globalScriptReadHandler;
        }
        if ("query-definitions".equals(tagName)) {
            this.queryDefinitionsReadHandler = new QueryDefinitionsReadHandler();
            return this.queryDefinitionsReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        AbstractNamedMDXDataFactory dataFactory = (AbstractNamedMDXDataFactory)this.getDataFactory();
        for (int i = 0; i < this.queries.size(); ++i) {
            PropertyReadHandler handler = this.queries.get(i);
            dataFactory.setQuery(handler.getName(), handler.getResult(), null, null);
        }
        if (this.globalScriptReadHandler != null) {
            dataFactory.setGlobalScript(this.globalScriptReadHandler.getResult());
            dataFactory.setGlobalScriptLanguage(this.globalScriptReadHandler.getName());
        }
        if (this.queryDefinitionsReadHandler != null) {
            ArrayList scriptedQueries = this.queryDefinitionsReadHandler.getScriptedQueries();
            for (QueryDefinitionReadHandler scriptedQuery : scriptedQueries) {
                dataFactory.setQuery(scriptedQuery.getName(), scriptedQuery.getQuery(), scriptedQuery.getScriptLanguage(), scriptedQuery.getScript());
            }
        }
    }
}

