/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DefaultCubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.JndiDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.CubeFileProviderReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.CubeFileProviderReadHandlerFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.DataSourceProviderReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.DataSourceProviderReadHandlerFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MondrianConnectionReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(MondrianConnectionReadHandler.class);
    private String driverClass;
    private String connectionString;
    private String mondrianCubeDefinitionFile;
    private String dataSourceName;
    private PropertiesReadHandler propertiesReadHandler;
    private String jdbcPassword;
    private String jdbcPasswordField;
    private String jdbcUser;
    private String jdbcUserField;
    private String designTimeName;
    private String role;
    private String roleField;
    private DataSourceProviderReadHandler dataSourceProviderHandler;
    private CubeFileProviderReadHandler cubeFileProviderReadHandler;

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public String getRole() {
        return this.role;
    }

    public String getRoleField() {
        return this.roleField;
    }

    public String getDesignTimeName() {
        return this.designTimeName;
    }

    public CubeFileProvider getCubeFileProvider() {
        if (this.cubeFileProviderReadHandler != null) {
            return this.cubeFileProviderReadHandler.getProvider();
        }
        if (this.mondrianCubeDefinitionFile != null) {
            return new DefaultCubeFileProvider(this.mondrianCubeDefinitionFile);
        }
        return null;
    }

    public DataSourceProvider getDataSourceProvider() {
        if (this.dataSourceProviderHandler != null) {
            return this.dataSourceProviderHandler.getProvider();
        }
        if (this.dataSourceName != null) {
            return new JndiDataSourceProvider(this.dataSourceName);
        }
        if (this.connectionString != null) {
            DriverDataSourceProvider driverDataSourceProvider = new DriverDataSourceProvider();
            driverDataSourceProvider.setDriver(this.driverClass);
            driverDataSourceProvider.setUrl(this.connectionString);
            if (this.propertiesReadHandler != null) {
                Properties p = this.propertiesReadHandler.getResult();
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    driverDataSourceProvider.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return driverDataSourceProvider;
        }
        return null;
    }

    public String getJdbcPasswordField() {
        return this.jdbcPasswordField;
    }

    public String getJdbcUserField() {
        return this.jdbcUserField;
    }

    private String readFiltered(Attributes attrs, String attr) {
        String value = attrs.getValue(this.getUri(), attr);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return value;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.dataSourceName = this.readFiltered(attrs, "datasource-name");
        this.connectionString = this.readFiltered(attrs, "connection-string");
        this.driverClass = this.readFiltered(attrs, "jdbc-driver");
        this.mondrianCubeDefinitionFile = this.readFiltered(attrs, "mondrian-cube-definition");
        this.designTimeName = this.readFiltered(attrs, "design-time-name");
        this.jdbcPassword = PasswordEncryptionService.getInstance().decrypt(this.getRootHandler(), this.readFiltered(attrs, "jdbc-password"));
        this.jdbcPasswordField = this.readFiltered(attrs, "jdbc-password-field");
        this.jdbcUser = this.readFiltered(attrs, "jdbc-user");
        this.jdbcUserField = this.readFiltered(attrs, "jdbc-user-field");
        this.role = this.readFiltered(attrs, "role");
        this.roleField = this.readFiltered(attrs, "role-field");
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        DataSourceProviderReadHandlerFactory dataSourceProviderReadHandlerFactory = DataSourceProviderReadHandlerFactory.getInstance();
        XmlReadHandler dataSourceHandler = dataSourceProviderReadHandlerFactory.getHandler(uri, tagName);
        if (dataSourceHandler instanceof DataSourceProviderReadHandler) {
            this.dataSourceProviderHandler = (DataSourceProviderReadHandler)dataSourceHandler;
            return this.dataSourceProviderHandler;
        }
        CubeFileProviderReadHandlerFactory cubeFileProviderReadHandlerFactory = CubeFileProviderReadHandlerFactory.getInstance();
        XmlReadHandler cubeHandler = cubeFileProviderReadHandlerFactory.getHandler(uri, tagName);
        if (cubeHandler instanceof CubeFileProviderReadHandler) {
            this.cubeFileProviderReadHandler = (CubeFileProviderReadHandler)cubeHandler;
            return this.cubeFileProviderReadHandler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("properties".equals(tagName)) {
            this.propertiesReadHandler = new PropertiesReadHandler();
            return this.propertiesReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.cubeFileProviderReadHandler != null && this.dataSourceProviderHandler != null) {
            return;
        }
        if (this.cubeFileProviderReadHandler == null && this.mondrianCubeDefinitionFile == null) {
            throw new ParseException("Mondrian-schema file is not defined.", this.getLocator());
        }
        if (this.dataSourceProviderHandler == null && this.dataSourceName == null && this.connectionString == null) {
            throw new ParseException("No Connection Information found. This is a invalid datasource.", this.getLocator());
        }
        logger.warn((Object)"This is a obsolete modrian-datasource definition. Load and save the report in PRD-3.5 to migrate it to the final version.");
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

