/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.vfs.ui;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.vfs.messages.Messages;

public class TextInputDialog {
    String title;
    String text;
    String enteredText;
    int width;
    int height;
    Shell dialog;
    boolean okPressed = false;
    Text textInput = null;

    public TextInputDialog(String title, String text, int width, int height) {
        this.title = title;
        this.text = text;
        this.width = width;
        this.height = height;
        this.init();
    }

    public String open() {
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        String returnValue = this.text;
        returnValue = this.okPressed ? this.enteredText : null;
        this.dialog.dispose();
        return returnValue;
    }

    public void init() {
        this.dialog = TextInputDialog.createModalDialogShell(this.width, this.height, this.title);
        this.dialog.setLayout((Layout)new GridLayout(4, false));
        Composite content = new Composite((Composite)this.dialog, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 4;
        content.setLayoutData((Object)gridData);
        content.setLayout((Layout)new GridLayout(1, false));
        this.textInput = new Text(content, 2052);
        gridData = new GridData(4, 4, true, true);
        this.textInput.setLayoutData((Object)gridData);
        this.textInput.setText(this.text);
        Label left = new Label((Composite)this.dialog, 0);
        gridData = new GridData(4, 4, true, false);
        left.setLayoutData((Object)gridData);
        final Button ok = new Button((Composite)this.dialog, 8);
        gridData = new GridData(131072, 4, false, false);
        ok.setLayoutData((Object)gridData);
        ok.setText(Messages.getString("TextInputDialog.ok"));
        Button cancel = new Button((Composite)this.dialog, 8);
        gridData = new GridData(131072, 4, false, false);
        cancel.setLayoutData((Object)gridData);
        cancel.setText(Messages.getString("TextInputDialog.cancel"));
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TextInputDialog.this.okPressed = e.getSource() == ok;
                TextInputDialog.this.enteredText = TextInputDialog.this.textInput.getText();
                TextInputDialog.this.dialog.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        ok.addSelectionListener(listener);
        this.textInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TextInputDialog.this.okPressed = true;
                    TextInputDialog.this.enteredText = TextInputDialog.this.textInput.getText();
                    TextInputDialog.this.dialog.close();
                } else {
                    TextInputDialog.this.okPressed = false;
                }
            }
        });
        cancel.addSelectionListener(listener);
    }

    public static void centerShellOnDisplay(Shell shell, Display display, int desiredWidth, int desiredHeight) {
        int screenWidth = display.getPrimaryMonitor().getBounds().width;
        int screenHeight = display.getPrimaryMonitor().getBounds().height;
        int applicationX = Math.abs(screenWidth - desiredWidth) / 2;
        int applicationY = Math.abs(screenHeight - desiredHeight) / 2;
        shell.setSize(desiredWidth, desiredHeight);
        shell.setLocation(applicationX, applicationY);
    }

    public static Shell createModalDialogShell(int desiredWidth, int desiredHeight, String title) {
        Shell shell = new Shell(Display.getCurrent(), 67680);
        shell.setText(title);
        try {
            shell.setImage(Display.getCurrent().getActiveShell().getImage());
        }
        catch (Throwable ignore) {
            try {
                shell.setImage(Display.getDefault().getActiveShell().getImage());
            }
            catch (Throwable ignore2) {
                // empty catch block
            }
        }
        TextInputDialog.centerShellOnDisplay(shell, Display.getCurrent(), desiredWidth, desiredHeight);
        return shell;
    }
}

