/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLParser
extends Parser {
    private static final HapiLog log = HapiLogFactory.getHapiLog(XMLParser.class);
    private DOMParser parser = new DOMParser((XMLParserConfiguration)new StandardParserConfiguration());
    private String textEncoding;
    private String[] keepAsOriginalNodes;
    private String concatKeepAsOriginalNodes = "";

    public XMLParser() {
        this(null);
    }

    public XMLParser(ModelClassFactory theFactory) {
        try {
            this.parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        }
        catch (Exception e) {
            log.error("Can't exclude whitespace from XML DOM", e);
        }
    }

    public String getEncoding(String message) {
        String encoding = null;
        String[] expected = new String[]{"<MSH.1", "<MSH.2", "</MSH>"};
        boolean isXML = true;
        int i = 0;
        while (i < expected.length) {
            if (message.indexOf(expected[i]) < 0) {
                isXML = false;
            }
            ++i;
        }
        if (isXML) {
            encoding = "XML";
        }
        return encoding;
    }

    public boolean supportsEncoding(String encoding) {
        return encoding.equals("XML");
    }

    public String getDefaultEncoding() {
        return "XML";
    }

    public void setKeepAsOriginalNodes(String[] keepAsOriginalNodes) {
        this.keepAsOriginalNodes = keepAsOriginalNodes;
        if (keepAsOriginalNodes.length != 0) {
            StringBuffer strBuf = new StringBuffer(keepAsOriginalNodes[0]);
            int i = 1;
            while (i < keepAsOriginalNodes.length) {
                strBuf.append("|");
                strBuf.append(keepAsOriginalNodes[i]);
                ++i;
            }
            this.concatKeepAsOriginalNodes = strBuf.toString();
        } else {
            this.concatKeepAsOriginalNodes = "";
        }
    }

    public String[] getKeepAsOriginalNodes() {
        return this.keepAsOriginalNodes;
    }

    public abstract Message parseDocument(Document var1, String var2) throws HL7Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message doParse(String message, String version) throws HL7Exception, EncodingNotSupportedException {
        Message m = null;
        try {
            Document doc = null;
            XMLParser xMLParser = this;
            synchronized (xMLParser) {
                this.parser.parse(new InputSource(new StringReader(message)));
                doc = this.parser.getDocument();
            }
            m = this.parseDocument(doc, version);
        }
        catch (SAXException e) {
            throw new HL7Exception("SAXException parsing XML", 207, e);
        }
        catch (IOException e) {
            throw new HL7Exception("IOException parsing XML", 207, e);
        }
        return m;
    }

    protected String doEncode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        if (!encoding.equals("XML")) {
            throw new EncodingNotSupportedException("XMLParser supports only XML encoding");
        }
        return this.encode(source);
    }

    protected String doEncode(Message source) throws HL7Exception {
        if (source instanceof GenericMessage) {
            throw new HL7Exception("Can't XML-encode a GenericMessage.  Message must have a recognized structure.");
        }
        Document doc = this.encodeDocument(source);
        doc.getDocumentElement().setAttribute("xmlns", "urn:hl7-org:v2xml");
        StringWriter out = new StringWriter();
        OutputFormat outputFormat = new OutputFormat("", null, true);
        if (this.textEncoding != null) {
            outputFormat.setEncoding(this.textEncoding);
        }
        XMLSerializer ser = new XMLSerializer((Writer)out, outputFormat);
        try {
            ser.serialize(doc);
        }
        catch (IOException e) {
            throw new HL7Exception("IOException serializing XML document to string", 207, e);
        }
        return out.toString();
    }

    public abstract Document encodeDocument(Message var1) throws HL7Exception;

    public void parse(Segment segmentObject, Element segmentElement) throws HL7Exception {
        HashSet<String> done = new HashSet<String>();
        NodeList all = segmentElement.getChildNodes();
        int i = 0;
        while (i < all.getLength()) {
            String elementName = all.item(i).getNodeName();
            if (all.item(i).getNodeType() == 1 && !done.contains(elementName)) {
                done.add(elementName);
                int index = elementName.indexOf(46);
                if (index >= 0 && elementName.length() > index) {
                    String fieldNumString = elementName.substring(index + 1);
                    int fieldNum = Integer.parseInt(fieldNumString);
                    this.parseReps(segmentObject, segmentElement, elementName, fieldNum);
                } else {
                    log.debug("Child of segment " + segmentObject.getName() + " doesn't look like a field: " + elementName);
                }
            }
            ++i;
        }
        if (segmentObject.getClass().getName().indexOf("OBX") >= 0) {
            Varies.fixOBX5(segmentObject, this.getFactory());
        }
    }

    private void parseReps(Segment segmentObject, Element segmentElement, String fieldName, int fieldNum) throws DataTypeException, HL7Exception {
        NodeList reps = segmentElement.getElementsByTagName(fieldName);
        int i = 0;
        while (i < reps.getLength()) {
            this.parse(segmentObject.getField(fieldNum, i), (Element)reps.item(i));
            ++i;
        }
    }

    public boolean encode(Segment segmentObject, Element segmentElement) throws HL7Exception {
        boolean hasValue = false;
        int n = segmentObject.numFields();
        int i = 1;
        while (i <= n) {
            String name = this.makeElementName(segmentObject, i);
            Type[] reps = segmentObject.getField(i);
            int j = 0;
            while (j < reps.length) {
                Element newNode = segmentElement.getOwnerDocument().createElement(name);
                boolean componentHasValue = this.encode(reps[j], newNode);
                if (componentHasValue) {
                    try {
                        segmentElement.appendChild(newNode);
                    }
                    catch (DOMException e) {
                        throw new HL7Exception("DOMException encoding Segment: ", 207, e);
                    }
                    hasValue = true;
                }
                ++j;
            }
            ++i;
        }
        return hasValue;
    }

    public void parse(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        if (datatypeObject instanceof Varies) {
            this.parseVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            this.parsePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            this.parseComposite((Composite)datatypeObject, datatypeElement);
        }
    }

    private void parseVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        if (!this.hasChildElement(datatypeElement)) {
            datatypeObject.setData(new GenericPrimitive(datatypeObject.getMessage()));
        } else {
            datatypeObject.setData(new GenericComposite(datatypeObject.getMessage()));
        }
        this.parse(datatypeObject.getData(), datatypeElement);
    }

    private boolean hasChildElement(Element e) {
        NodeList children = e.getChildNodes();
        boolean hasElement = false;
        int c = 0;
        while (c < children.getLength() && !hasElement) {
            if (children.item(c).getNodeType() == 1) {
                hasElement = true;
            }
            ++c;
        }
        return hasElement;
    }

    private void parsePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        NodeList children = datatypeElement.getChildNodes();
        int c = 0;
        boolean full = false;
        while (c < children.getLength() && !full) {
            Node child;
            if ((child = children.item(c++)).getNodeType() != 3) continue;
            try {
                if (child.getNodeValue() != null && !child.getNodeValue().equals("")) {
                    if (this.keepAsOriginal(child.getParentNode())) {
                        datatypeObject.setValue(child.getNodeValue());
                    } else {
                        datatypeObject.setValue(this.removeWhitespace(child.getNodeValue()));
                    }
                }
            }
            catch (DOMException e) {
                log.error("Error parsing primitive value from TEXT_NODE", e);
            }
            full = true;
        }
    }

    protected boolean keepAsOriginal(Node node) {
        if (node.getNodeName() == null) {
            return false;
        }
        return this.concatKeepAsOriginalNodes.indexOf(node.getNodeName()) != -1;
    }

    protected String removeWhitespace(String s) {
        s = s.replace('\r', ' ');
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        boolean repeatedSpacesExist = true;
        while (repeatedSpacesExist) {
            int loc = s.indexOf("  ");
            if (loc < 0) {
                repeatedSpacesExist = false;
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(s.substring(0, loc));
            buf.append(" ");
            buf.append(s.substring(loc + 2));
            s = buf.toString();
        }
        return s.trim();
    }

    private void parseComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        if (datatypeObject instanceof GenericComposite) {
            NodeList children = datatypeElement.getChildNodes();
            int compNum = 0;
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    Element nextElement = (Element)children.item(i);
                    String localName = nextElement.getLocalName();
                    int dotIndex = localName.indexOf(".");
                    if (dotIndex > -1) {
                        compNum = Integer.parseInt(localName.substring(dotIndex + 1)) - 1;
                    } else {
                        log.debug("Datatype element " + datatypeElement.getLocalName() + " doesn't have a valid numbered name, usgin default index of " + compNum);
                    }
                    Type nextComponent = datatypeObject.getComponent(compNum);
                    this.parse(nextComponent, nextElement);
                    ++compNum;
                }
                ++i;
            }
        } else {
            Type[] children = datatypeObject.getComponents();
            int i = 0;
            while (i < children.length) {
                NodeList matchingElements = datatypeElement.getElementsByTagName(this.makeElementName(datatypeObject, i + 1));
                if (matchingElements.getLength() > 0) {
                    this.parse(children[i], (Element)matchingElements.item(0));
                }
                ++i;
            }
        }
    }

    private String makeElementName(Segment s, int child) {
        return String.valueOf(s.getName()) + "." + child;
    }

    private String makeElementName(Composite composite, int child) {
        return String.valueOf(composite.getName()) + "." + child;
    }

    private boolean encode(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject instanceof Varies) {
            hasData = this.encodeVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            hasData = this.encodePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            hasData = this.encodeComposite((Composite)datatypeObject, datatypeElement);
        }
        return hasData;
    }

    private boolean encodeVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject.getData() != null) {
            hasData = this.encode(datatypeObject.getData(), datatypeElement);
        }
        return hasData;
    }

    private boolean encodePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasValue = false;
        if (datatypeObject.getValue() != null && !datatypeObject.getValue().equals("")) {
            hasValue = true;
        }
        Text t = datatypeElement.getOwnerDocument().createTextNode(datatypeObject.getValue());
        if (hasValue) {
            try {
                datatypeElement.appendChild(t);
            }
            catch (DOMException e) {
                throw new DataTypeException("DOMException encoding Primitive: ", e);
            }
        }
        return hasValue;
    }

    private boolean encodeComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        Type[] components = datatypeObject.getComponents();
        boolean hasValue = false;
        int i = 0;
        while (i < components.length) {
            String name = this.makeElementName(datatypeObject, i + 1);
            Element newNode = datatypeElement.getOwnerDocument().createElement(name);
            boolean componentHasValue = this.encode(components[i], newNode);
            if (componentHasValue) {
                try {
                    datatypeElement.appendChild(newNode);
                }
                catch (DOMException e) {
                    throw new DataTypeException("DOMException encoding Composite: ", e);
                }
                hasValue = true;
            }
            ++i;
        }
        return hasValue;
    }

    public Segment getCriticalResponseData(String message) throws HL7Exception {
        String version = this.getVersion(message);
        Segment criticalData = Parser.makeControlMSH(version, this.getFactory());
        Terser.set(criticalData, 1, 0, 1, 1, this.parseLeaf(message, "MSH.1", 0));
        Terser.set(criticalData, 2, 0, 1, 1, this.parseLeaf(message, "MSH.2", 0));
        Terser.set(criticalData, 10, 0, 1, 1, this.parseLeaf(message, "MSH.10", 0));
        String procID = this.parseLeaf(message, "MSH.11", 0);
        if (procID == null || procID.length() == 0) {
            procID = this.parseLeaf(message, "PT.1", message.indexOf("MSH.11"));
        }
        Terser.set(criticalData, 11, 0, 1, 1, procID);
        return criticalData;
    }

    public String getAckID(String message) {
        String ackID = null;
        try {
            ackID = this.parseLeaf(message, "msa.2", 0).trim();
        }
        catch (HL7Exception hL7Exception) {
            // empty catch block
        }
        return ackID;
    }

    public String getVersion(String message) throws HL7Exception {
        String version = this.parseLeaf(message, "MSH.12", 0);
        if (version == null || version.trim().length() == 0) {
            version = this.parseLeaf(message, "VID.1", message.indexOf("MSH.12"));
        }
        return version;
    }

    protected String parseLeaf(String message, String tagName, int startAt) throws HL7Exception {
        String value = null;
        int tagStart = message.indexOf("<" + tagName, startAt);
        if (tagStart < 0) {
            tagStart = message.indexOf("<" + tagName.toUpperCase(), startAt);
        }
        int valStart = message.indexOf(">", tagStart) + 1;
        int valEnd = message.indexOf("<", valStart);
        if (tagStart < 0 || valEnd < valStart) {
            throw new HL7Exception("Couldn't find " + tagName + " in message beginning: " + message.substring(0, Math.min(150, message.length())), 101);
        }
        value = message.substring(valStart, valEnd);
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        return value;
    }

    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Message message, String string) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: XMLParser pipe_encoded_file");
            System.exit(1);
        }
        try {
            PipeParser parser = new PipeParser();
            File messageFile = new File(args[0]);
            long fileLength = messageFile.length();
            FileReader r = new FileReader(messageFile);
            char[] cbuf = new char[(int)fileLength];
            System.out.println("Reading message file ... " + r.read(cbuf) + " of " + fileLength + " chars");
            r.close();
            String messString = String.valueOf(cbuf);
            Message mess = parser.parse(messString);
            System.out.println("Got message of type " + mess.getClass().getName());
            XMLParser xp = new XMLParser(){

                public Message parseDocument(Document XMLMessage, String version) throws HL7Exception {
                    return null;
                }

                public Document encodeDocument(Message source) throws HL7Exception {
                    return null;
                }

                public String getVersion(String message) throws HL7Exception {
                    return null;
                }

                public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            String[] structNames = mess.getNames();
            int i = 0;
            while (i < structNames.length) {
                Structure[] reps = mess.getAll(structNames[i]);
                int j = 0;
                while (j < reps.length) {
                    if (Segment.class.isAssignableFrom(reps[j].getClass())) {
                        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document doc = docBuilder.newDocument();
                        Element root = doc.createElement(reps[j].getClass().getName());
                        doc.appendChild(root);
                        xp.encode((Segment)reps[j], root);
                        StringWriter out = new StringWriter();
                        XMLSerializer ser = new XMLSerializer((Writer)out, null);
                        ser.serialize(doc);
                        System.out.println("Segment " + reps[j].getClass().getName() + ": \r\n" + out.toString());
                        Class[] segmentConstructTypes = new Class[]{Message.class};
                        Object[] segmentConstructArgs = new Object[1];
                        Segment s = (Segment)reps[j].getClass().getConstructor(segmentConstructTypes).newInstance(segmentConstructArgs);
                        xp.parse(s, root);
                        Document doc2 = docBuilder.newDocument();
                        Element root2 = doc2.createElement(s.getClass().getName());
                        doc2.appendChild(root2);
                        xp.encode(s, root2);
                        StringWriter out2 = new StringWriter();
                        ser = new XMLSerializer((Writer)out2, null);
                        ser.serialize(doc2);
                        if (out2.toString().equals(out.toString())) {
                            System.out.println("Re-encode OK");
                        } else {
                            System.out.println("Warning: XML different after parse and re-encode: \r\n" + out2.toString());
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }
}

