/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hdfs.vfs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.pentaho.hdfs.vfs.HDFSFileSystem;

public class HDFSFileObject
extends AbstractFileObject
implements FileObject {
    private FileSystem hdfs;

    protected HDFSFileObject(FileName name, HDFSFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.hdfs = fileSystem.getHDFSFileSystem();
    }

    protected long doGetContentSize() throws Exception {
        return this.hdfs.getFileStatus(new Path(this.getName().getPath())).getLen();
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        if (append) {
            FSDataOutputStream out = this.hdfs.append(new Path(this.getName().getPath()));
            return out;
        }
        FSDataOutputStream out = this.hdfs.create(new Path(this.getName().getPath()));
        return out;
    }

    protected InputStream doGetInputStream() throws Exception {
        FSDataInputStream in = this.hdfs.open(new Path(this.getName().getPath()));
        return in;
    }

    protected FileType doGetType() throws Exception {
        FileStatus status = null;
        try {
            status = this.hdfs.getFileStatus(new Path(URLDecoder.decode(this.getName().getPath(), "UTF-8").replaceAll(" ", "+")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (status == null) {
            return FileType.IMAGINARY;
        }
        if (status.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    public void doCreateFolder() throws Exception {
        this.hdfs.mkdirs(new Path(this.getName().getPath()));
    }

    public void doDelete() throws Exception {
        this.hdfs.delete(new Path(this.getName().getPath()), true);
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.hdfs.rename(new Path(this.getName().getPath()), new Path(newfile.getName().getPath()));
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.hdfs.getFileStatus(new Path(this.getName().getPath())).getModificationTime();
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        this.hdfs.setTimes(new Path(this.getName().getPath()), modtime, System.currentTimeMillis());
    }

    protected String[] doListChildren() throws Exception {
        FileStatus[] statusList = this.hdfs.listStatus(new Path(this.getName().getPath()));
        String[] children = new String[statusList.length];
        for (int i = 0; i < statusList.length; ++i) {
            children[i] = URLEncoder.encode(statusList[i].getPath().getName(), "UTF-8");
        }
        return children;
    }
}

