/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;

public class LazyByte
extends LazyPrimitive<LazyByteObjectInspector, ByteWritable> {
    public LazyByte(LazyByteObjectInspector oi) {
        super(oi);
        this.data = new ByteWritable();
    }

    public LazyByte(LazyByte copy) {
        super(copy);
        this.data = new ByteWritable(((ByteWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        try {
            ((ByteWritable)this.data).set(LazyByte.parseByte(bytes.getData(), start, length, 10));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
        }
    }

    public static byte parseByte(byte[] bytes, int start, int length) {
        return LazyByte.parseByte(bytes, start, length, 10);
    }

    public static byte parseByte(byte[] bytes, int start, int length, int radix) {
        int intValue = LazyInteger.parseInt(bytes, start, length, radix);
        byte result = (byte)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException();
    }
}

