/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseConnectionPoolParameter;
import org.pentaho.di.core.database.DatabaseFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDatabaseMeta
implements Cloneable {
    public static final String ATTRIBUTE_PORT_NUMBER = "PORT_NUMBER";
    public static final String ATTRIBUTE_SQL_CONNECT = "SQL_CONNECT";
    public static final String ATTRIBUTE_USE_POOLING = "USE_POOLING";
    public static final String ATTRIBUTE_MAXIMUM_POOL_SIZE = "MAXIMUM_POOL_SIZE";
    public static final String ATTRIBUTE_INITIAL_POOL_SIZE = "INITIAL_POOL_SIZE";
    public static final String ATTRIBUTE_PREFIX_EXTRA_OPTION = "EXTRA_OPTION_";
    public static final String ATTRIBUTE_IS_CLUSTERED = "IS_CLUSTERED";
    private static final String ATTRIBUTE_CLUSTER_PARTITION_PREFIX = "CLUSTER_PARTITION_";
    public static final String ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX = "CLUSTER_HOSTNAME_";
    public static final String ATTRIBUTE_CLUSTER_PORT_PREFIX = "CLUSTER_PORT_";
    public static final String ATTRIBUTE_CLUSTER_DBNAME_PREFIX = "CLUSTER_DBNAME_";
    public static final String ATTRIBUTE_CLUSTER_USERNAME_PREFIX = "CLUSTER_USERNAME_";
    public static final String ATTRIBUTE_CLUSTER_PASSWORD_PREFIX = "CLUSTER_PASSWORD_";
    public static final String ATTRIBUTE_POOLING_PARAMETER_PREFIX = "POOLING_";
    public static final String ATTRIBUTE_USE_RESULT_STREAMING = "STREAM_RESULTS";
    public static final String ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR = "MSSQL_DOUBLE_DECIMAL_SEPARATOR";
    public static final String ATTRIBUTE_QUOTE_ALL_FIELDS = "QUOTE_ALL_FIELDS";
    public static final String ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE = "FORCE_IDENTIFIERS_TO_LOWERCASE";
    public static final String ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE = "FORCE_IDENTIFIERS_TO_UPPERCASE";
    public static final String ATTRIBUTE_PREFERRED_SCHEMA_NAME = "PREFERRED_SCHEMA_NAME";
    public static final String ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE = "SUPPORTS_BOOLEAN_DATA_TYPE";
    public static final String SEQUENCE_FOR_BATCH_ID = "SEQUENCE_FOR_BATCH_ID";
    public static final String AUTOINCREMENT_SQL_FOR_BATCH_ID = "AUTOINCREMENT_SQL_FOR_BATCH_ID";
    protected boolean releaseSavepoint = true;
    public static final String SELECT_COUNT_STATEMENT = "select count(*) FROM";
    public static final DatabaseConnectionPoolParameter[] poolingParameters = new DatabaseConnectionPoolParameter[]{new DatabaseConnectionPoolParameter("defaultAutoCommit", "true", "The default auto-commit state of connections created by this pool."), new DatabaseConnectionPoolParameter("defaultReadOnly", null, "The default read-only state of connections created by this pool.\nIf not set then the setReadOnly method will not be called.\n (Some drivers don't support read only mode, ex: Informix)"), new DatabaseConnectionPoolParameter("defaultTransactionIsolation", null, "the default TransactionIsolation state of connections created by this pool. One of the following: (see javadoc)\n\n  * NONE\n  * READ_COMMITTED\n  * READ_UNCOMMITTED\n  * REPEATABLE_READ  * SERIALIZABLE\n"), new DatabaseConnectionPoolParameter("defaultCatalog", null, "The default catalog of connections created by this pool."), new DatabaseConnectionPoolParameter("initialSize", "0", "The initial number of connections that are created when the pool is started."), new DatabaseConnectionPoolParameter("maxActive", "8", "The maximum number of active connections that can be allocated from this pool at the same time, or non-positive for no limit."), new DatabaseConnectionPoolParameter("maxIdle", "8", "The maximum number of connections that can remain idle in the pool, without extra ones being released, or negative for no limit."), new DatabaseConnectionPoolParameter("minIdle", "0", "The minimum number of connections that can remain idle in the pool, without extra ones being created, or zero to create none."), new DatabaseConnectionPoolParameter("maxWait", "-1", "The maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception, or -1 to wait indefinitely."), new DatabaseConnectionPoolParameter("validationQuery", null, "The SQL query that will be used to validate connections from this pool before returning them to the caller.\nIf specified, this query MUST be an SQL SELECT statement that returns at least one row."), new DatabaseConnectionPoolParameter("testOnBorrow", "true", "The indication of whether objects will be validated before being borrowed from the pool.\nIf the object fails to validate, it will be dropped from the pool, and we will attempt to borrow another.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("testOnReturn", "false", "The indication of whether objects will be validated before being returned to the pool.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("testWhileIdle", "false", "The indication of whether objects will be validated by the idle object evictor (if any). If an object fails to validate, it will be dropped from the pool.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("timeBetweenEvictionRunsMillis", null, "The number of milliseconds to sleep between runs of the idle object evictor thread. When non-positive, no idle object evictor thread will be run."), new DatabaseConnectionPoolParameter("poolPreparedStatements", "false", "Enable prepared statement pooling for this pool."), new DatabaseConnectionPoolParameter("maxOpenPreparedStatements", "-1", "The maximum number of open statements that can be allocated from the statement pool at the same time, or zero for no limit."), new DatabaseConnectionPoolParameter("accessToUnderlyingConnectionAllowed", "false", "Controls if the PoolGuard allows access to the underlying connection."), new DatabaseConnectionPoolParameter("removeAbandoned", "false", "Flag to remove abandoned connections if they exceed the removeAbandonedTimout.\nIf set to true a connection is considered abandoned and eligible for removal if it has been idle longer than the removeAbandonedTimeout. Setting this to true can recover db connections from poorly written applications which fail to close a connection."), new DatabaseConnectionPoolParameter("removeAbandonedTimeout", "300", "Timeout in seconds before an abandoned connection can be removed."), new DatabaseConnectionPoolParameter("logAbandoned", "false", "Flag to log stack traces for application code which abandoned a Statement or Connection.\nLogging of abandoned Statements and Connections adds overhead for every Connection open or new Statement because a stack trace has to be generated.")};
    private String name;
    private int accessType;
    private String hostname;
    private String databaseName;
    private String username;
    private String password;
    private String servername;
    private String dataTablespace;
    private String indexTablespace;
    private boolean changed = false;
    private Properties attributes = new Properties();
    private ObjectId objectId;
    private String pluginId;
    private String pluginName;

    public BaseDatabaseMeta() {
        if (this.getAccessTypeList() != null && this.getAccessTypeList().length > 0) {
            this.accessType = this.getAccessTypeList()[0];
        }
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public abstract int[] getAccessTypeList();

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
        if (this.accessType == 4) {
            this.username = "";
            this.password = "";
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDatabasePortNumberString(String databasePortNumberString) {
        if (databasePortNumberString != null) {
            this.getAttributes().put(ATTRIBUTE_PORT_NUMBER, databasePortNumberString);
        }
    }

    public String getDatabasePortNumberString() {
        return this.getAttributes().getProperty(ATTRIBUTE_PORT_NUMBER, "-1");
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId id) {
        this.objectId = id;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = this.accessType == 4 ? "" : password;
    }

    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public String getDataTablespace() {
        return this.dataTablespace;
    }

    public void setDataTablespace(String dataTablespace) {
        this.dataTablespace = dataTablespace;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (this.accessType == 4) {
            this.username = "";
        }
        this.username = username;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    public Object clone() {
        BaseDatabaseMeta retval = null;
        try {
            retval = (BaseDatabaseMeta)super.clone();
            retval.attributes = (Properties)this.attributes.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    public int getDefaultDatabasePort() {
        return -1;
    }

    public boolean supportsSetCharacterStream() {
        return true;
    }

    public boolean supportsAutoInc() {
        return true;
    }

    public String getLimitClause(int nrRows) {
        return "";
    }

    public int getNotFoundTK(boolean use_autoinc) {
        return 0;
    }

    public String getSQLNextSequenceValue(String sequenceName) {
        return "";
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "";
    }

    public String getSQLSequenceExists(String sequenceName) {
        return "";
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean needsPlaceHolder() {
        return false;
    }

    public boolean supportsSchemas() {
        return true;
    }

    public boolean supportsCatalogs() {
        return true;
    }

    public boolean supportsEmptyTransactions() {
        return true;
    }

    public String getFunctionSum() {
        return "SUM";
    }

    public String getFunctionAverage() {
        return "AVG";
    }

    public String getFunctionMinimum() {
        return "MIN";
    }

    public String getFunctionMaximum() {
        return "MAX";
    }

    public String getFunctionCount() {
        return "COUNT";
    }

    public String getSchemaTableCombination(String schema_name, String table_part) {
        return schema_name + "." + table_part;
    }

    public String getBackwardsCompatibleSchemaTableCombination(String schemaPart, String tablePart) {
        String schemaTable = "";
        schemaTable = schemaPart != null && (schemaPart.contains(this.getStartQuote()) || schemaPart.contains(this.getEndQuote())) ? schemaTable + schemaPart : schemaTable + this.getStartQuote() + schemaPart + this.getEndQuote();
        schemaTable = schemaTable + ".";
        schemaTable = tablePart != null && (tablePart.contains(this.getStartQuote()) || tablePart.contains(this.getEndQuote())) ? schemaTable + tablePart : schemaTable + this.getStartQuote() + tablePart + this.getEndQuote();
        return schemaTable;
    }

    public String getBackwardsCompatibleTable(String tablePart) {
        if (tablePart != null && tablePart.contains(this.getStartQuote()) || tablePart.contains(this.getEndQuote())) {
            return tablePart;
        }
        return this.getStartQuote() + tablePart + this.getEndQuote();
    }

    public int getMaxTextFieldLength() {
        return 9999999;
    }

    public int getMaxVARCHARLength() {
        return 9999999;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return true;
    }

    public boolean supportsSetLong() {
        return true;
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP " + v.getName() + Const.CR;
    }

    public String[] getReservedWords() {
        return new String[0];
    }

    public boolean quoteReservedWords() {
        return true;
    }

    public String getStartQuote() {
        return "\"";
    }

    public String getEndQuote() {
        return "\"";
    }

    public boolean supportsRepository() {
        return true;
    }

    public String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    public String[] getViewTypes() {
        return new String[]{"VIEW"};
    }

    public String[] getSynonymTypes() {
        return new String[]{"SYNONYM"};
    }

    public boolean useSchemaNameForTableList() {
        return false;
    }

    public boolean supportsViews() {
        return true;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getSQLListOfProcedures() {
        return null;
    }

    public String getSQLListOfSequences() {
        return null;
    }

    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName;
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return true;
    }

    public String getSQLLockTables(String[] tableNames) {
        return null;
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    public boolean supportsTimeStampToDateConversion() {
        return true;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public boolean supportsBooleanDataType() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE, "N");
        return "Y".equalsIgnoreCase(usePool);
    }

    public void setSupportsBooleanDataType(boolean b) {
        this.attributes.setProperty(ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE, b ? "Y" : "N");
    }

    public boolean isDefaultingToUppercase() {
        return true;
    }

    public Map<String, String> getExtraOptions() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Enumeration<Object> keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String attribute = (String)keys.nextElement();
            if (!attribute.startsWith(ATTRIBUTE_PREFIX_EXTRA_OPTION)) continue;
            String value = this.attributes.getProperty(attribute, "");
            map.put(attribute.substring(ATTRIBUTE_PREFIX_EXTRA_OPTION.length()), value);
        }
        return map;
    }

    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.attributes.put(ATTRIBUTE_PREFIX_EXTRA_OPTION + databaseTypeCode + "." + option, value);
    }

    public String getExtraOptionSeparator() {
        return ";";
    }

    public String getExtraOptionValueSeparator() {
        return "=";
    }

    public String getExtraOptionIndicator() {
        return ";";
    }

    public boolean supportsOptionsInURL() {
        return true;
    }

    public String getExtraOptionsHelpText() {
        return null;
    }

    public boolean supportsGetBlob() {
        return true;
    }

    public String getConnectSQL() {
        return this.attributes.getProperty(ATTRIBUTE_SQL_CONNECT);
    }

    public void setConnectSQL(String sql) {
        this.attributes.setProperty(ATTRIBUTE_SQL_CONNECT, sql);
    }

    public boolean supportsSetMaxRows() {
        return true;
    }

    public boolean isUsingConnectionPool() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_USE_POOLING);
        return "Y".equalsIgnoreCase(usePool);
    }

    public void setUsingConnectionPool(boolean usePool) {
        this.attributes.setProperty(ATTRIBUTE_USE_POOLING, usePool ? "Y" : "N");
    }

    public int getMaximumPoolSize() {
        return Const.toInt((String)this.attributes.getProperty(ATTRIBUTE_MAXIMUM_POOL_SIZE), (int)10);
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.attributes.setProperty(ATTRIBUTE_MAXIMUM_POOL_SIZE, Integer.toString(maximumPoolSize));
    }

    public int getInitialPoolSize() {
        return Const.toInt((String)this.attributes.getProperty(ATTRIBUTE_INITIAL_POOL_SIZE), (int)5);
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.attributes.setProperty(ATTRIBUTE_INITIAL_POOL_SIZE, Integer.toString(initialPoolSize));
    }

    public boolean isPartitioned() {
        String isClustered = this.attributes.getProperty(ATTRIBUTE_IS_CLUSTERED);
        return "Y".equalsIgnoreCase(isClustered);
    }

    public void setPartitioned(boolean clustered) {
        this.attributes.setProperty(ATTRIBUTE_IS_CLUSTERED, clustered ? "Y" : "N");
    }

    public PartitionDatabaseMeta[] getPartitioningInformation() {
        int nr = 0;
        while (this.attributes.getProperty(ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX + nr) != null) {
            ++nr;
        }
        PartitionDatabaseMeta[] clusterInfo = new PartitionDatabaseMeta[nr];
        for (nr = 0; nr < clusterInfo.length; ++nr) {
            String partitionId = this.attributes.getProperty(ATTRIBUTE_CLUSTER_PARTITION_PREFIX + nr);
            String hostname = this.attributes.getProperty(ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX + nr);
            String port = this.attributes.getProperty(ATTRIBUTE_CLUSTER_PORT_PREFIX + nr);
            String dbName = this.attributes.getProperty(ATTRIBUTE_CLUSTER_DBNAME_PREFIX + nr);
            String username = this.attributes.getProperty(ATTRIBUTE_CLUSTER_USERNAME_PREFIX + nr);
            String password = this.attributes.getProperty(ATTRIBUTE_CLUSTER_PASSWORD_PREFIX + nr);
            clusterInfo[nr] = new PartitionDatabaseMeta(partitionId, hostname, port, dbName);
            clusterInfo[nr].setUsername(username);
            clusterInfo[nr].setPassword(Encr.decryptPasswordOptionallyEncrypted((String)password));
        }
        return clusterInfo;
    }

    public void setPartitioningInformation(PartitionDatabaseMeta[] clusterInfo) {
        for (int nr = 0; nr < clusterInfo.length; ++nr) {
            PartitionDatabaseMeta meta = clusterInfo[nr];
            this.attributes.put(ATTRIBUTE_CLUSTER_PARTITION_PREFIX + nr, Const.NVL((String)meta.getPartitionId(), (String)""));
            this.attributes.put(ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX + nr, Const.NVL((String)meta.getHostname(), (String)""));
            this.attributes.put(ATTRIBUTE_CLUSTER_PORT_PREFIX + nr, Const.NVL((String)meta.getPort(), (String)""));
            this.attributes.put(ATTRIBUTE_CLUSTER_DBNAME_PREFIX + nr, Const.NVL((String)meta.getDatabaseName(), (String)""));
            this.attributes.put(ATTRIBUTE_CLUSTER_USERNAME_PREFIX + nr, Const.NVL((String)meta.getUsername(), (String)""));
            this.attributes.put(ATTRIBUTE_CLUSTER_PASSWORD_PREFIX + nr, Const.NVL((String)Encr.encryptPasswordIfNotUsingVariables((String)meta.getPassword()), (String)""));
        }
    }

    public Properties getConnectionPoolingProperties() {
        Properties properties = new Properties();
        for (String string : this.attributes.keySet()) {
            if (!string.startsWith(ATTRIBUTE_POOLING_PARAMETER_PREFIX)) continue;
            String key = string.substring(ATTRIBUTE_POOLING_PARAMETER_PREFIX.length());
            String value = this.attributes.getProperty(string);
            properties.put(key, value);
        }
        return properties;
    }

    public void setConnectionPoolingProperties(Properties properties) {
        for (String string : this.attributes.keySet()) {
            if (!string.startsWith(ATTRIBUTE_POOLING_PARAMETER_PREFIX)) continue;
            this.attributes.remove(string);
        }
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            if (Const.isEmpty((String)string) || Const.isEmpty((String)value)) continue;
            this.attributes.put(ATTRIBUTE_POOLING_PARAMETER_PREFIX + string, value);
        }
    }

    public String getSQLTableExists(String tablename) {
        return "SELECT 1 FROM " + tablename;
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT " + columnname + " FROM " + tablename;
    }

    public boolean needsToLockAllTables() {
        return true;
    }

    public boolean isStreamingResults() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_USE_RESULT_STREAMING, "Y");
        return "Y".equalsIgnoreCase(usePool);
    }

    public void setStreamingResults(boolean useStreaming) {
        this.attributes.setProperty(ATTRIBUTE_USE_RESULT_STREAMING, useStreaming ? "Y" : "N");
    }

    public boolean isQuoteAllFields() {
        String quoteAllFields = this.attributes.getProperty(ATTRIBUTE_QUOTE_ALL_FIELDS, "N");
        return "Y".equalsIgnoreCase(quoteAllFields);
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.attributes.setProperty(ATTRIBUTE_QUOTE_ALL_FIELDS, quoteAllFields ? "Y" : "N");
    }

    public boolean isForcingIdentifiersToLowerCase() {
        String forceLowerCase = this.attributes.getProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE, "N");
        return "Y".equalsIgnoreCase(forceLowerCase);
    }

    public void setForcingIdentifiersToLowerCase(boolean forceLowerCase) {
        this.attributes.setProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE, forceLowerCase ? "Y" : "N");
    }

    public boolean isForcingIdentifiersToUpperCase() {
        String forceUpperCase = this.attributes.getProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE, "N");
        return "Y".equalsIgnoreCase(forceUpperCase);
    }

    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        this.attributes.setProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE, forceUpperCase ? "Y" : "N");
    }

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR, "N");
        return "Y".equalsIgnoreCase(usePool);
    }

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        this.attributes.setProperty(ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR, useDoubleDecimalSeparator ? "Y" : "N");
    }

    public boolean isRequiringTransactionsOnQueries() {
        return true;
    }

    public String getDatabaseFactoryName() {
        return DatabaseFactory.class.getName();
    }

    public String getPreferredSchemaName() {
        return this.attributes.getProperty(ATTRIBUTE_PREFERRED_SCHEMA_NAME);
    }

    public void setPreferredSchemaName(String preferredSchemaName) {
        this.attributes.setProperty(ATTRIBUTE_PREFERRED_SCHEMA_NAME, preferredSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = database.getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            block8: {
                ResultSet indexList = null;
                try {
                    indexList = database.getDatabaseMetaData().getIndexInfo(null, null, tablename, false, true);
                    while (indexList.next()) {
                        String column = indexList.getString("COLUMN_NAME");
                        int idx = Const.indexOfString((String)column, (String[])idx_fields);
                        if (idx < 0) continue;
                        exists[idx] = true;
                    }
                    Object var11_13 = null;
                    if (indexList == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (indexList != null) {
                        indexList.close();
                    }
                    throw throwable;
                }
                indexList.close();
            }
            boolean all = true;
            for (int i = 0; i < exists.length && all; ++i) {
                if (exists[i]) continue;
                all = false;
            }
            return all;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", (Throwable)e);
        }
    }

    public boolean supportsSequenceNoMaxValueOption() {
        return false;
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return false;
    }

    public boolean requiresCastToVariousForIsNull() {
        return false;
    }

    public boolean isDisplaySizeTwiceThePrecision() {
        return false;
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return true;
    }

    public boolean supportsResultSetMetadataRetrievalOnly() {
        return false;
    }

    public boolean isSystemTable(String tableName) {
        return false;
    }

    public boolean supportsNewLinesInSQL() {
        return true;
    }

    public String getSQLListOfSchemas() {
        return null;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public boolean supportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (0, 1)";
    }

    public boolean isExplorable() {
        return true;
    }

    public String getXulOverlayFile() {
        return null;
    }

    public String quoteSQLString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "\\\\n");
        string = string.replaceAll("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public String getSelectCountStatement(String tableName) {
        return "select count(*) FROM " + tableName;
    }

    public String generateColumnAlias(int columnIndex, String suggestedName) {
        return "COL" + Integer.toString(columnIndex);
    }

    public List<String> parseStatements(String sqlScript) {
        ArrayList<String> statements = new ArrayList<String>();
        String all = sqlScript;
        int from = 0;
        int to = 0;
        int length = all.length();
        while (to < length) {
            int nextBacktickIndex;
            int nextDQuoteIndex;
            char c = all.charAt(to);
            while (all.substring(from).startsWith("--")) {
                int nextLineIndex = all.indexOf(Const.CR, from);
                from = nextLineIndex + Const.CR.length();
                if (to >= length) break;
                c = all.charAt(c);
            }
            if (to >= length) break;
            if (c == '\"' && (nextDQuoteIndex = all.indexOf(34, to + 1)) >= 0) {
                to = nextDQuoteIndex + 1;
            }
            if (c == '`' && (nextBacktickIndex = all.indexOf(96, to + 1)) >= 0) {
                to = nextBacktickIndex + 1;
            }
            if ((c = all.charAt(to)) == '\'') {
                char prevChar;
                boolean skip = true;
                if (to > 0 && ((prevChar = all.charAt(to - 1)) == '\\' || prevChar == '\'')) {
                    skip = false;
                }
                while (skip) {
                    char prevChar2;
                    char nextChar;
                    int nextQuoteIndex = all.indexOf(39, to + 1);
                    if (nextQuoteIndex < 0) continue;
                    to = nextQuoteIndex + 1;
                    skip = false;
                    if (to < all.length() && (nextChar = all.charAt(to)) == '\'') {
                        skip = true;
                        ++to;
                    }
                    if (to <= 0 || (prevChar2 = all.charAt(to - 2)) != '\\') continue;
                    skip = true;
                    ++to;
                }
            }
            if ((c = all.charAt(to)) == ';' || to >= length - 1) {
                String stat;
                if (to >= length - 1) {
                    ++to;
                }
                if (!this.onlySpaces(stat = all.substring(from, to))) {
                    statements.add(Const.trim((String)stat));
                }
                from = ++to;
                continue;
            }
            ++to;
        }
        return statements;
    }

    protected boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    public boolean isMySQLVariant() {
        return false;
    }

    public boolean releaseSavepoint() {
        return this.releaseSavepoint;
    }

    public Long getNextBatchIdUsingSequence(String sequenceName, String schemaName, DatabaseMeta dbm, Database ldb) throws KettleDatabaseException {
        return ldb.getNextSequenceValue(schemaName, sequenceName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getNextBatchIdUsingAutoIncSQL(String autoIncSQL, DatabaseMeta dbm, Database ldb) throws KettleDatabaseException {
        Long rtn = null;
        PreparedStatement stmt = ldb.prepareSQL(autoIncSQL, true);
        try {
            try {
                stmt.executeUpdate();
                RowMetaAndData rmad = ldb.getGeneratedKeys(stmt);
                if (rmad.getRowMeta().size() <= 0) throw new KettleDatabaseException("Unable to retrieve value of auto-generated technical key : no value found!");
                rtn = rmad.getRowMeta().getInteger(rmad.getData(), 0);
                Object var8_9 = null;
            }
            catch (KettleValueException kve) {
                throw new KettleDatabaseException((Throwable)kve);
            }
            catch (SQLException sqlex) {
                throw new KettleDatabaseException((Throwable)sqlex);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ignored) {}
        stmt.close();
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextBatchIdUsingLockTables(DatabaseMeta dbm, Database ldb, String schemaName, String tableName, String fieldName) throws KettleDatabaseException {
        String sql3;
        Long rtn = null;
        String schemaAndTable = dbm.getQuotedSchemaTableCombination(schemaName, tableName);
        ldb.lockTables(new String[]{schemaAndTable});
        try {
            String sql2 = "INSERT INTO " + schemaAndTable + " (" + dbm.quoteField(fieldName) + ") values (-1)";
            ldb.execStatement(sql2);
            rtn = ldb.getNextValue(null, schemaName, tableName, fieldName);
            Object var10_9 = null;
            sql3 = "DELETE FROM " + schemaAndTable + " WHERE " + dbm.quoteField(fieldName) + "= -1";
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            String sql3 = "DELETE FROM " + schemaAndTable + " WHERE " + dbm.quoteField(fieldName) + "= -1";
            ldb.execStatement(sql3);
            ldb.unlockTables(new String[]{schemaAndTable});
            throw throwable;
        }
        ldb.execStatement(sql3);
        ldb.unlockTables(new String[]{schemaAndTable});
        return rtn;
    }

    public Long getNextBatchId(DatabaseMeta dbm, Database ldb, String schemaName, String tableName, String fieldName) throws KettleDatabaseException {
        ldb.setCommit(10);
        Map<String, String> connectionExtraOptions = this.getExtraOptions();
        String sequenceProp = this.getPluginId() + "." + SEQUENCE_FOR_BATCH_ID;
        String autoIncSQLProp = this.getPluginId() + "." + AUTOINCREMENT_SQL_FOR_BATCH_ID;
        if (connectionExtraOptions != null) {
            if (this.supportsSequences() && connectionExtraOptions.containsKey(sequenceProp)) {
                return this.getNextBatchIdUsingSequence(connectionExtraOptions.get(sequenceProp), schemaName, dbm, ldb);
            }
            if (this.supportsAutoInc() && connectionExtraOptions.containsKey(autoIncSQLProp)) {
                return this.getNextBatchIdUsingAutoIncSQL(connectionExtraOptions.get(autoIncSQLProp), dbm, ldb);
            }
        }
        return this.getNextBatchIdUsingLockTables(dbm, ldb, schemaName, tableName, fieldName);
    }

    public String getDataTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta) {
        return this.getTablespaceDDL(variables, databaseMeta, databaseMeta.getDatabaseInterface().getDataTablespace());
    }

    public String getIndexTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta) {
        return this.getTablespaceDDL(variables, databaseMeta, databaseMeta.getDatabaseInterface().getIndexTablespace());
    }

    public String getTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta, String tablespaceName) {
        return "";
    }

    public Object getValueFromResultSet(ResultSet rs, ValueMetaInterface val, int i) throws KettleDatabaseException {
        Object data = null;
        try {
            switch (val.getType()) {
                case 4: {
                    data = rs.getBoolean(i + 1);
                    break;
                }
                case 1: {
                    data = new Double(rs.getDouble(i + 1));
                    break;
                }
                case 6: {
                    data = rs.getBigDecimal(i + 1);
                    break;
                }
                case 5: {
                    data = rs.getLong(i + 1);
                    break;
                }
                case 2: {
                    if (val.isStorageBinaryString()) {
                        data = rs.getBytes(i + 1);
                        break;
                    }
                    data = rs.getString(i + 1);
                    break;
                }
                case 8: {
                    if (this.supportsGetBlob()) {
                        Blob blob = rs.getBlob(i + 1);
                        if (blob != null) {
                            data = blob.getBytes(1L, (int)blob.length());
                            break;
                        }
                        data = null;
                        break;
                    }
                    data = rs.getBytes(i + 1);
                    break;
                }
                case 3: {
                    if (val.getPrecision() != 1 && this.supportsTimeStampToDateConversion()) {
                        data = rs.getTimestamp(i + 1);
                        break;
                    }
                    data = rs.getDate(i + 1);
                    break;
                }
            }
            if (rs.wasNull()) {
                data = null;
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get value '" + val.toStringMeta() + "' from database resultset, index " + i, (Throwable)e);
        }
        return data;
    }

    public boolean useSafePoints() {
        return false;
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

