/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.i18n.BaseMessages;

public class DatabaseFactory
implements DatabaseFactoryInterface {
    private static Class<?> PKG = Database.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Database factory", LoggingObjectType.GENERAL, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionTestReport(DatabaseMeta databaseMeta) throws KettleDatabaseException {
        if (databaseMeta.getAccessType() != 3) {
            StringBuffer report = new StringBuffer();
            Database db = new Database(loggingObject, databaseMeta);
            if (databaseMeta.isPartitioned()) {
                PartitionDatabaseMeta[] partitioningInformation = databaseMeta.getPartitioningInformation();
                for (int i = 0; i < partitioningInformation.length; ++i) {
                    Object var8_8;
                    try {
                        try {
                            db.connect(partitioningInformation[i].getPartitionId());
                            report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.ConnectionWithPartOk", (String[])new String[]{databaseMeta.getName(), partitioningInformation[i].getPartitionId()}) + Const.CR);
                        }
                        catch (KettleException e) {
                            report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.ConnectionWithPartError", (String[])new String[]{databaseMeta.getName(), partitioningInformation[i].getPartitionId(), e.toString()}) + Const.CR);
                            report.append(Const.getStackTracker((Throwable)e) + Const.CR);
                            var8_8 = null;
                            db.disconnect();
                        }
                        var8_8 = null;
                        db.disconnect();
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        db.disconnect();
                        throw throwable;
                    }
                    this.appendConnectionInfo(report, db.environmentSubstitute(partitioningInformation[i].getHostname()), db.environmentSubstitute(partitioningInformation[i].getPort()), db.environmentSubstitute(partitioningInformation[i].getDatabaseName()));
                    report.append(Const.CR);
                }
            } else {
                try {
                    try {
                        db.connect();
                        report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.ConnectionOk", (String[])new String[]{databaseMeta.getName()}) + Const.CR);
                    }
                    catch (KettleException e) {
                        report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.ConnectionError", (String[])new String[]{databaseMeta.getName()}) + e.toString() + Const.CR);
                        report.append(Const.getStackTracker((Throwable)e) + Const.CR);
                        Object var10_11 = null;
                        db.disconnect();
                    }
                    Object var10_10 = null;
                    db.disconnect();
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    db.disconnect();
                    throw throwable;
                }
                if (databaseMeta.getAccessType() == 4) {
                    this.appendJndiConnectionInfo(report, db.environmentSubstitute(databaseMeta.getDatabaseName()));
                } else {
                    this.appendConnectionInfo(report, db.environmentSubstitute(databaseMeta.getHostname()), db.environmentSubstitute(databaseMeta.getDatabasePortNumberString()), db.environmentSubstitute(databaseMeta.getDatabaseName()));
                }
                report.append(Const.CR);
            }
            return report.toString();
        }
        return BaseMessages.getString(PKG, (String)"BaseDatabaseMeta.TestConnectionReportNotImplemented.Message", (String[])new String[0]);
    }

    private StringBuffer appendJndiConnectionInfo(StringBuffer report, String jndiName) {
        report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.JndiName", (String[])new String[0])).append(jndiName).append(Const.CR);
        return report;
    }

    private StringBuffer appendConnectionInfo(StringBuffer report, String hostName, String portNumber, String dbName) {
        report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.Hostname", (String[])new String[0])).append(hostName).append(Const.CR);
        report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.Port", (String[])new String[0])).append(portNumber).append(Const.CR);
        report.append(BaseMessages.getString(PKG, (String)"DatabaseMeta.report.DatabaseName", (String[])new String[0])).append(dbName).append(Const.CR);
        return report;
    }
}

