/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class InformixDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1526;
        }
        return -1;
    }

    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.informix.jdbc.IfxDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:informix-sqli://" + hostname + ":" + port + "/" + databaseName + ":INFORMIXSERVER=" + this.getServername();
    }

    public boolean needsPlaceHolder() {
        return true;
    }

    public boolean needsToLockAllTables() {
        return false;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT FIRST 1 * FROM " + tableName;
    }

    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT FIRST 1 " + columnname + " FROM " + tableName;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME YEAR to FRACTION";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "SERIAL8";
                        break;
                    }
                    retval = retval + "INTEGER PRIMARY KEY";
                    break;
                }
                if (length < 0 && precision < 0 || precision > 0 || length > 9) {
                    retval = retval + "FLOAT";
                    break;
                }
                retval = retval + "INTEGER";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "CLOB";
                    break;
                }
                if (length < 256) {
                    retval = retval + "VARCHAR";
                    if (length <= 0) break;
                    retval = retval + "(" + length + ")";
                    break;
                }
                if (length < 32768) {
                    retval = retval + "LVARCHAR";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getSQLLockTables(String[] tableNames) {
        String sql = "";
        for (int i = 0; i < tableNames.length; ++i) {
            sql = sql + "LOCK TABLE " + tableNames[i] + " IN EXCLUSIVE MODE;" + Const.CR;
        }
        return sql;
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    public String[] getUsedLibraries() {
        return new String[]{"ifxjdbc.jar"};
    }

    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }
}

