/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;

public class MSSQLServerNativeDatabaseMeta
extends MSSQLServerDatabaseMeta {
    public static final String ATTRIBUTE_USE_INTEGRATED_SECURITY = "MSSQLUseIntegratedSecurity";

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        String useIntegratedSecurity = null;
        Object value = this.getAttributes().get(ATTRIBUTE_USE_INTEGRATED_SECURITY);
        if (value != null && value instanceof String) {
            useIntegratedSecurity = (String)value;
            try {
                Boolean.parseBoolean(useIntegratedSecurity);
            }
            catch (IllegalArgumentException e) {
                useIntegratedSecurity = "false";
            }
        }
        String url = "jdbc:sqlserver://" + hostname;
        if (!Const.isEmpty((String)port) && Const.toInt((String)port, (int)-1) > 0) {
            url = url + ":" + port;
        }
        url = url + ";databaseName=" + databaseName + ";integratedSecurity=" + useIntegratedSecurity;
        return url;
    }
}

