/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeradataDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "com.teradata.jdbc.TeraDriver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            String url = "jdbc:teradata://" + hostname;
            if (!StringUtils.isEmpty((String)databaseName)) {
                url = url + "/DATABASE=" + databaseName;
            }
            return url;
        }
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return this.getBackwardsCompatibleSchemaTableCombination(schema_name, table_part);
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsRepository() {
        return true;
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return "show table " + tablename;
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT * FROM DBC.columns WHERE tablename =" + tablename + " AND columnname =" + columnname;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 9) {
                        retval = retval + "DECIMAL(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 5) {
                        retval = retval + "INTEGER";
                        break;
                    }
                    if (length < 3) {
                        retval = retval + "BYTEINT";
                        break;
                    }
                    retval = retval + "SMALLINT";
                    break;
                }
                retval = retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                if (length > 64000) {
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "VARCHAR";
                if (length > 0) {
                    retval = retval + "(" + length + ")";
                    break;
                }
                retval = retval + "(64000)";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String getExtraOptionSeparator() {
        return ",";
    }

    @Override
    public String getExtraOptionIndicator() {
        return "/";
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://www.info.ncr.com/eTeradata-BrowseBy-Results.cfm?pl=&PID=&title=%25&release=&kword=CJDBC&sbrn=7&nm=Teradata+Tools+and+Utilities+-+Java+Database+Connectivity+(JDBC)";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"terajdbc4.jar", "tdgssjava.jar"};
    }

    @Override
    public int getDefaultDatabasePort() {
        return 1025;
    }

    @Override
    public Map<String, String> getExtraOptions() {
        Map<String, String> map = super.getExtraOptions();
        if (!Const.isEmpty((String)this.getDatabasePortNumberString())) {
            map.put(this.getPluginId() + ".DBS_PORT", this.getDatabasePortNumberString());
        }
        return map;
    }
}

