/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import org.apache.hadoop.io.LongWritable;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleTypeToLongWritableConverter
implements ITypeConverter<Object, LongWritable> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return TypeConverterFactory.isKettleType(from) && LongWritable.class.equals((Object)to);
    }

    @Override
    public LongWritable convert(ValueMetaInterface meta, Object obj) throws TypeConversionException {
        try {
            LongWritable result = new LongWritable();
            result.set(meta.getInteger(obj).longValue());
            return result;
        }
        catch (KettleValueException ex) {
            throw new TypeConversionException(BaseMessages.getString(TypeConverterFactory.class, (String)"ErrorConverting", (Object[])new Object[]{LongWritable.class.getSimpleName(), obj}), ex);
        }
    }
}

