/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.haivvreo;

import com.linkedin.haivvreo.HaivvreoException;
import com.linkedin.haivvreo.HaivvreoUtils;
import com.linkedin.haivvreo.InstanceCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

class SchemaToTypeInfo {
    private static final Map<Schema.Type, TypeInfo> primitiveTypeToTypeInfo = SchemaToTypeInfo.initTypeMap();
    static InstanceCache<Schema, TypeInfo> typeInfoCache = new InstanceCache<Schema, TypeInfo>(){

        @Override
        protected TypeInfo makeInstance(Schema s) throws HaivvreoException {
            return SchemaToTypeInfo.generateTypeInfoWorker(s);
        }
    };
    private static final TypeInfo FIXED_AND_BYTES_EQUIV = TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.byteTypeInfo);

    SchemaToTypeInfo() {
    }

    private static Map<Schema.Type, TypeInfo> initTypeMap() {
        Hashtable<Schema.Type, TypeInfo> theMap = new Hashtable<Schema.Type, TypeInfo>();
        theMap.put(Schema.Type.STRING, TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        theMap.put(Schema.Type.INT, TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        theMap.put(Schema.Type.BOOLEAN, TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        theMap.put(Schema.Type.LONG, TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        theMap.put(Schema.Type.FLOAT, TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        theMap.put(Schema.Type.DOUBLE, TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        theMap.put(Schema.Type.NULL, TypeInfoFactory.getPrimitiveTypeInfo((String)"void"));
        return Collections.unmodifiableMap(theMap);
    }

    public static List<TypeInfo> generateColumnTypes(Schema schema) throws HaivvreoException {
        List fields = schema.getFields();
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(fields.size());
        for (Schema.Field field : fields) {
            types.add(SchemaToTypeInfo.generateTypeInfo(field.schema()));
        }
        return types;
    }

    public static TypeInfo generateTypeInfo(Schema schema) throws HaivvreoException {
        return typeInfoCache.retrieve(schema);
    }

    private static TypeInfo generateTypeInfoWorker(Schema schema) throws HaivvreoException {
        if (HaivvreoUtils.isNullableType(schema)) {
            return SchemaToTypeInfo.generateTypeInfo(HaivvreoUtils.getOtherTypeFromNullableType(schema));
        }
        Schema.Type type = schema.getType();
        if (primitiveTypeToTypeInfo.containsKey(type)) {
            return primitiveTypeToTypeInfo.get(type);
        }
        switch (type) {
            case BYTES: {
                return SchemaToTypeInfo.generateBytesTypeInfo(schema);
            }
            case RECORD: {
                return SchemaToTypeInfo.generateRecordTypeInfo(schema);
            }
            case MAP: {
                return SchemaToTypeInfo.generateMapTypeInfo(schema);
            }
            case ARRAY: {
                return SchemaToTypeInfo.generateArrayTypeInfo(schema);
            }
            case UNION: {
                return SchemaToTypeInfo.generateUnionTypeInfo(schema);
            }
            case ENUM: {
                return SchemaToTypeInfo.generateEnumTypeInfo(schema);
            }
            case FIXED: {
                return SchemaToTypeInfo.generateFixedTypeInfo(schema);
            }
        }
        throw new HaivvreoException("Do not yet support: " + schema);
    }

    private static TypeInfo generateRecordTypeInfo(Schema schema) throws HaivvreoException {
        assert (schema.getType().equals((Object)Schema.Type.RECORD));
        List fields = schema.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldNames.add(i, ((Schema.Field)fields.get(i)).name());
            typeInfos.add(i, SchemaToTypeInfo.generateTypeInfo(((Schema.Field)fields.get(i)).schema()));
        }
        return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
    }

    private static TypeInfo generateMapTypeInfo(Schema schema) throws HaivvreoException {
        assert (schema.getType().equals((Object)Schema.Type.MAP));
        Schema valueType = schema.getValueType();
        TypeInfo ti = SchemaToTypeInfo.generateTypeInfo(valueType);
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (TypeInfo)ti);
    }

    private static TypeInfo generateArrayTypeInfo(Schema schema) throws HaivvreoException {
        assert (schema.getType().equals((Object)Schema.Type.ARRAY));
        Schema itemsType = schema.getElementType();
        TypeInfo itemsTypeInfo = SchemaToTypeInfo.generateTypeInfo(itemsType);
        return TypeInfoFactory.getListTypeInfo((TypeInfo)itemsTypeInfo);
    }

    private static TypeInfo generateUnionTypeInfo(Schema schema) throws HaivvreoException {
        assert (schema.getType().equals((Object)Schema.Type.UNION));
        List types = schema.getTypes();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(types.size());
        for (Schema type : types) {
            typeInfos.add(SchemaToTypeInfo.generateTypeInfo(type));
        }
        return TypeInfoFactory.getUnionTypeInfo(typeInfos);
    }

    private static TypeInfo generateEnumTypeInfo(Schema schema) {
        assert (schema.getType().equals((Object)Schema.Type.ENUM));
        return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
    }

    private static TypeInfo generateFixedTypeInfo(Schema schema) {
        assert (schema.getType().equals((Object)Schema.Type.FIXED));
        return FIXED_AND_BYTES_EQUIV;
    }

    private static TypeInfo generateBytesTypeInfo(Schema schema) {
        assert (schema.getType().equals((Object)Schema.Type.BYTES));
        return FIXED_AND_BYTES_EQUIV;
    }
}

