/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.messages;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.pentaho.metadata.messages.LocaleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messages {
    private static final String BUNDLE_NAME = "org.pentaho.metadata.messages.messages";
    private static final Map<Locale, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());

    protected static Map<Locale, ResourceBundle> getLocales() {
        return locales;
    }

    private static ResourceBundle getBundle() {
        Locale locale = LocaleHelper.getLocale();
        ResourceBundle bundle = locales.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
            locales.put(locale, bundle);
        }
        return bundle;
    }

    public static String getString(String key, Object ... params) {
        return Messages.getString(Messages.getBundle(), key, params);
    }

    public static String getErrorString(String key, Object ... params) {
        return Messages.getErrorString(Messages.getBundle(), key, params);
    }

    public static String formatErrorMessage(String key, String msg) {
        int end = key.indexOf(".ERROR_");
        end = end < 0 ? key.length() : Math.min(end + ".ERROR_0000".length(), key.length());
        return Messages.getString("Messages.ERROR_FORMAT_MASK", key.substring(0, end), msg);
    }

    public static String getErrorString(ResourceBundle bundle, String key, Object ... params) {
        return Messages.formatErrorMessage(key, Messages.getString(bundle, key, params));
    }

    public static String getString(ResourceBundle bundle, String key, Object ... params) {
        try {
            return MessageFormat.format(bundle.getString(key), params);
        }
        catch (Exception e) {
            return '!' + key + '!';
        }
    }
}

