/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.LocaleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends Concept {
    private static final long serialVersionUID = -9093116797722021640L;
    public static final String LOCALES_PROPERTY = "locales";
    private List<IPhysicalModel> physicalModels = new ArrayList<IPhysicalModel>();
    private List<LogicalModel> logicalModels = new ArrayList<LogicalModel>();
    private List<Concept> concepts = new ArrayList<Concept>();

    @Override
    public List<String> getUniqueId() {
        return null;
    }

    @Override
    public IConcept getParent() {
        return null;
    }

    @Override
    public List<IConcept> getChildren() {
        ArrayList<IConcept> children = new ArrayList<IConcept>();
        children.addAll(this.physicalModels);
        children.addAll(this.logicalModels);
        children.addAll(this.concepts);
        return children;
    }

    public List<IPhysicalModel> getPhysicalModels() {
        return this.physicalModels;
    }

    public void setPhysicalModels(List<IPhysicalModel> physicalModels) {
        this.physicalModels = physicalModels;
    }

    public void addPhysicalModel(IPhysicalModel physicalModel) {
        this.physicalModels.add(physicalModel);
    }

    public List<LogicalModel> getLogicalModels() {
        return this.logicalModels;
    }

    public void setLogicalModels(List<LogicalModel> logicalModels) {
        this.logicalModels = logicalModels;
    }

    public void addLogicalModel(LogicalModel logicalModel) {
        this.logicalModels.add(logicalModel);
    }

    public List<Concept> getConcepts() {
        return this.concepts;
    }

    public void setConcepts(List<Concept> concepts) {
        this.concepts = concepts;
    }

    public void addConcept(Concept concept) {
        this.concepts.add(concept);
    }

    public void setLocales(List<LocaleType> locales) {
        this.setProperty(LOCALES_PROPERTY, locales);
    }

    public List<LocaleType> getLocales() {
        return (List)this.getProperty(LOCALES_PROPERTY);
    }

    public String[] getLocaleCodes() {
        if (this.getLocales() == null) {
            return null;
        }
        String[] locales = new String[this.getLocales().size()];
        for (int i = 0; i < this.getLocales().size(); ++i) {
            locales[i] = this.getLocales().get(i).getCode();
        }
        return locales;
    }

    public void addLocale(LocaleType locale) {
        this.getLocales().add(locale);
    }

    public LogicalModel findLogicalModel(String modelId) {
        for (LogicalModel model : this.getLogicalModels()) {
            if (!modelId.equals(model.getId())) continue;
            return model;
        }
        return null;
    }

    public IPhysicalTable findPhysicalTable(String tableId) {
        for (IPhysicalModel model : this.getPhysicalModels()) {
            for (IPhysicalTable iPhysicalTable : model.getPhysicalTables()) {
                if (!tableId.equals(iPhysicalTable.getId())) continue;
                return iPhysicalTable;
            }
        }
        return null;
    }

    public IPhysicalModel findPhysicalModel(String modelId) {
        for (IPhysicalModel model : this.getPhysicalModels()) {
            if (!modelId.equals(model.getId())) continue;
            return model;
        }
        return null;
    }

    public Concept findConcept(String conceptId) {
        for (Concept concept : this.getConcepts()) {
            if (!conceptId.equals(concept.getId())) continue;
            return concept;
        }
        return null;
    }

    @Override
    public Object clone() {
        Domain clone = new Domain();
        this.clone(clone);
        clone.physicalModels = this.physicalModels;
        clone.concepts = this.concepts;
        clone.setLogicalModels(new ArrayList<LogicalModel>());
        for (LogicalModel model : this.getLogicalModels()) {
            clone.addLogicalModel((LogicalModel)model.clone());
        }
        return clone;
    }
}

