/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.metadata.model.IMetadataQueryExec;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.repository.IMetadataDomainRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMetadataQueryExec
implements IMetadataQueryExec {
    private boolean doQueryLog;
    private Integer maxRows;
    private Integer timeout;
    private boolean readOnly = true;
    private boolean forwardOnly = false;
    public IMetadataDomainRepository metadataDomainRepository;
    private IPhysicalModel physicalModel;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected Map<String, Object> inputs = new HashMap<String, Object>();

    @Override
    public void setDoQueryLog(boolean doQueryLog) {
        this.doQueryLog = doQueryLog;
    }

    @Override
    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean getDoQueryLog() {
        return this.doQueryLog;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public IMetadataDomainRepository getMetadataDomainRepository() {
        return this.metadataDomainRepository;
    }

    @Override
    public void setMetadataDomainRepository(IMetadataDomainRepository metadataDomainRepository) {
        this.metadataDomainRepository = metadataDomainRepository;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isForwardOnly() {
        return this.forwardOnly;
    }

    @Override
    public void setForwardOnly(boolean forwardOnly) {
        this.forwardOnly = forwardOnly;
    }

    public IPhysicalModel getPhysicalModel() {
        return this.physicalModel;
    }

    @Override
    public void setPhysicalModel(IPhysicalModel physicalModel) {
        this.physicalModel = physicalModel;
    }

    @Override
    public void setParameter(Parameter param, Object value) {
        if (value != null) {
            this.parameters.put(param.getName(), value);
        } else {
            this.parameters.put(param.getName(), param.getDefaultValue());
        }
    }

    @Override
    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    protected Object convertParameterValue(Parameter param, Object paramObj) {
        if (paramObj == null) {
            return null;
        }
        switch (param.getType()) {
            case NUMERIC: {
                if (paramObj instanceof Number) break;
                try {
                    paramObj = Double.parseDouble(paramObj.toString());
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case BOOLEAN: {
                if (paramObj instanceof Boolean) break;
                paramObj = Boolean.parseBoolean(paramObj.toString());
                break;
            }
            case STRING: {
                if (paramObj instanceof String) break;
                paramObj = paramObj.toString();
            }
        }
        return paramObj;
    }
}

