/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.example;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.query.example.AdvancedSqlGenerator;
import org.pentaho.metadata.query.example.AliasedSelection;
import org.pentaho.metadata.query.impl.sql.SqlOpenFormula;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.pms.core.exception.PentahoMetadataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasAwareSqlOpenFormula
extends SqlOpenFormula {
    private static final Log logger = LogFactory.getLog(AliasAwareSqlOpenFormula.class);
    private List<Selection> selections;
    private String aliasName;
    private Map<String, String> LogicalTableToAliasMap;
    private Map<String, AliasedSelection> aliasedSelectionMap = new HashMap<String, AliasedSelection>();
    List<AdvancedSqlGenerator.AliasedPathLogicalTable> aliasedTables = new ArrayList<AdvancedSqlGenerator.AliasedPathLogicalTable>();

    public AliasAwareSqlOpenFormula(LogicalModel model, DatabaseMeta databaseMeta, String formulaString, List<Selection> selections, String aliasName) throws PentahoMetadataException {
        super(model, databaseMeta, formulaString, null, null, false);
        this.selections = selections;
        this.aliasName = aliasName;
    }

    public AliasAwareSqlOpenFormula(LogicalModel model, LogicalTable table, DatabaseMeta databaseMeta, String formulaString, String aliasName) throws PentahoMetadataException {
        super(model, table, databaseMeta, formulaString, null, null, false);
        this.aliasName = aliasName;
    }

    public void setLogicalTableToAliasMap(Map<String, String> LogicalTableToAlias) {
        this.LogicalTableToAliasMap = LogicalTableToAlias;
    }

    @Override
    protected void addField(String fieldName) throws PentahoMetadataException {
        if (this.selections != null && fieldName != null && fieldName.indexOf(".") >= 0) {
            String[] names = fieldName.split("\\.");
            for (Selection selection : this.selections) {
                AliasedSelection aliasedSelection = (AliasedSelection)selection;
                if (aliasedSelection.getAlias() == null || !aliasedSelection.getAlias().equals(names[0])) continue;
                LogicalColumn column = this.getLogicalModel().findLogicalColumn(names[1]);
                if (column != null) {
                    AliasedSelection sel = new AliasedSelection(null, column, null, aliasedSelection.getAlias());
                    this.aliasedSelectionMap.put(fieldName, sel);
                    this.getSelections().add(sel);
                    return;
                }
                throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0011_INVALID_FIELDNAME", fieldName));
            }
        }
        super.addField(fieldName);
    }

    @Override
    protected void renderContextLookup(StringBuffer sb, String contextName, String locale) {
        AliasedSelection sel = this.aliasedSelectionMap.get(contextName);
        if (sel != null) {
            sb.append(" ");
            AdvancedSqlGenerator.SQLAndAliasedTables sqlAndTables = AdvancedSqlGenerator.getSelectionSQL(this.getLogicalModel(), sel, this.getDatabaseMeta(), locale);
            sb.append(sqlAndTables.getSql());
            sb.append(" ");
            for (AdvancedSqlGenerator.AliasedPathLogicalTable aliasedTable : sqlAndTables.getAliasedLogicalTables()) {
                if (this.aliasedTables.contains(aliasedTable)) continue;
                this.aliasedTables.add(aliasedTable);
            }
            return;
        }
        Selection column = (Selection)this.getSelectionMap().get(contextName);
        if (column == null) {
            String tableColumn = "";
            sb.append(" ");
            LogicalTable LogicalTable2 = this.findLogicalTableForContextName(contextName, locale);
            if (LogicalTable2 != null) {
                sb.append(this.getDatabaseMeta().quoteField(LogicalTable2.getId()));
                sb.append(".");
            }
            sb.append(this.getDatabaseMeta().quoteField(contextName));
            sb.append(" ");
        } else {
            AliasedSelection selection = null;
            if (this.LogicalTableToAliasMap != null) {
                String tmpAliasName = this.LogicalTableToAliasMap.get(column.getLogicalColumn().getLogicalTable().getId());
                if (tmpAliasName == null) {
                    tmpAliasName = this.aliasName;
                }
                selection = new AliasedSelection(null, column.getLogicalColumn(), null, tmpAliasName);
            } else {
                selection = new AliasedSelection(null, column.getLogicalColumn(), null, this.aliasName);
            }
            sb.append(" ");
            AdvancedSqlGenerator.SQLAndAliasedTables sqlAndTables = AdvancedSqlGenerator.getSelectionSQL(this.getLogicalModel(), selection, this.getDatabaseMeta(), locale);
            sb.append(sqlAndTables.getSql());
            sb.append(" ");
            for (AdvancedSqlGenerator.AliasedPathLogicalTable aliasedTable : sqlAndTables.getAliasedLogicalTables()) {
                if (this.aliasedTables.contains(aliasedTable)) continue;
                this.aliasedTables.add(aliasedTable);
            }
        }
    }

    @Override
    public String[] getLogicalTableIDs() {
        throw new UnsupportedOperationException();
    }

    public String[] getTableAliasNames() {
        String[] tables = new String[this.aliasedTables.size()];
        for (int i = 0; i < this.aliasedTables.size(); ++i) {
            tables[i] = this.aliasedTables.get(i).getAlias();
        }
        return tables;
    }

    public List<AdvancedSqlGenerator.AliasedPathLogicalTable> getUsedAliasedTables() {
        return this.aliasedTables;
    }
}

