/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TargetColumnType;
import org.pentaho.metadata.query.impl.sql.SqlAndTables;
import org.pentaho.metadata.query.impl.sql.SqlGenerator;
import org.pentaho.metadata.query.impl.sql.SqlOpenFormulaContext;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.SQLDialectFactory;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLFunctionGeneratorInterface;
import org.pentaho.pms.mql.dialect.SQLOperatorGeneratorInterface;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.PrefixTerm;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlOpenFormula
implements FormulaTraversalInterface {
    private static final String PARAM = "param:";
    private static final Log logger = LogFactory.getLog(SqlOpenFormula.class);
    private List<LogicalTable> tables;
    private LogicalModel model = null;
    private DatabaseMeta databaseMeta = null;
    private Formula formulaObject = null;
    private Map<String, Selection> selectionMap = new HashMap<String, Selection>();
    private Map<LogicalTable, String> tableAliases;
    private List<Selection> selections = new ArrayList<Selection>();
    private SqlOpenFormulaContext formulaContext = SqlOpenFormulaContext.getInstance();
    private SQLDialectInterface sqlDialect = null;
    private boolean isValidated = false;
    private boolean allowAggregateFunctions = false;
    private boolean hasAggregateFunction = false;
    private Map<String, Object> parameters;
    private String formulaString;
    private boolean genAsPreparedStatement;
    Boolean hasAgg;

    public SqlOpenFormula(LogicalModel model, DatabaseMeta databaseMeta, String formulaString, Map<LogicalTable, String> tableAliases, Map<String, Object> parameters, boolean genAsPreparedStatement) throws PentahoMetadataException {
        this.model = model;
        this.formulaString = formulaString;
        this.databaseMeta = databaseMeta;
        this.tableAliases = tableAliases;
        this.tables = new ArrayList<LogicalTable>();
        this.parameters = parameters;
        this.genAsPreparedStatement = genAsPreparedStatement;
        if (model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0001_NO_BUSINESS_MODEL_PROVIDED", new Object[0]));
        }
        if (databaseMeta == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0002_NO_DATABASE_META_PROVIDED", new Object[0]));
        }
        this.sqlDialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        if (this.sqlDialect == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0018_DATABASE_DIALECT_NOT_FOUND", databaseMeta.getDatabaseTypeDesc()));
        }
        if (formulaString == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0003_NO_FORMULA_STRING_PROVIDED", new Object[0]));
        }
    }

    public SqlOpenFormula(LogicalModel model, LogicalTable table, DatabaseMeta databaseMeta, String formulaString, Map<LogicalTable, String> tableAliases, Map<String, Object> parameters, boolean genAsPreparedStatement) throws PentahoMetadataException {
        this.model = model;
        this.formulaString = formulaString;
        this.databaseMeta = databaseMeta;
        this.tableAliases = tableAliases;
        this.tables = new ArrayList<LogicalTable>();
        this.tables.add(table);
        this.parameters = parameters;
        this.genAsPreparedStatement = genAsPreparedStatement;
        if (model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0001_NO_BUSINESS_MODEL_PROVIDED", new Object[0]));
        }
        if (databaseMeta == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0002_NO_DATABASE_META_PROVIDED", new Object[0]));
        }
        if (table == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0004_NO_BUSINESS_TABLE_PROVIDED", new Object[0]));
        }
        this.sqlDialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        if (this.sqlDialect == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0015_DATABASE_DIALECT_NOT_FOUND", databaseMeta.getDatabaseTypeDesc()));
        }
        if (formulaString == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0003_NO_FORMULA_STRING_PROVIDED", new Object[0]));
        }
    }

    public void setTableAliases(Map<LogicalTable, String> tableAliases) {
        this.tableAliases = tableAliases;
    }

    protected DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public List<LogicalTable> getLogicalTables() {
        return this.tables;
    }

    protected LogicalModel getLogicalModel() {
        return this.model;
    }

    protected Map getSelectionMap() {
        return this.selectionMap;
    }

    public void parseAndValidate() throws PentahoMetadataException {
        if (!this.isValidated) {
            try {
                this.formulaObject = new Formula(this.formulaString);
                this.formulaObject.initialize((FormulaContext)this.formulaContext);
                LValue val = this.formulaObject.getRootReference();
                this.validateAndResolveObjectModel(val);
                this.isValidated = true;
            }
            catch (ParseException e) {
                logger.debug((Object)"an exception occurred", (Throwable)e);
                throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0005_FAILED_TO_PARSE_FORMULA", this.formulaString));
            }
            catch (EvaluationException e) {
                logger.debug((Object)"an exception occurred", (Throwable)e);
                throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0006_FAILED_TO_EVALUATE_FORMULA", this.formulaString));
            }
            catch (Throwable e) {
                if (e instanceof PentahoMetadataException) {
                    throw (PentahoMetadataException)e;
                }
                logger.debug((Object)"an exception occurred", e);
                throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0007_UNKNOWN_ERROR", this.formulaString));
            }
        }
    }

    protected void addField(String fieldName) throws PentahoMetadataException {
        if (fieldName == null) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0008_FIELDNAME_NULL", this.formulaString));
        }
        if (!this.selectionMap.containsKey(fieldName)) {
            String aggregation;
            if (fieldName.startsWith(PARAM)) {
                String paramName = fieldName.substring(6);
                if (!this.parameters.containsKey(paramName)) {
                    throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_00XX_PARAM_NOT_FOUND", paramName));
                }
                return;
            }
            if (fieldName.indexOf(".") < 0) {
                if (this.tables == null) {
                    throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0009_FIELDNAME_ERROR_NO_BUSINESS_TABLE", fieldName));
                }
                for (LogicalTable table : this.tables) {
                    for (LogicalColumn column : table.getLogicalColumns()) {
                        if (column.getProperty("target_column_type") != TargetColumnType.COLUMN_NAME || !fieldName.equals(column.getProperty("target_column"))) continue;
                        return;
                    }
                }
                throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0010_FIELDNAME_ERROR_COLUMN_NOT_FOUND", fieldName, fieldName, SqlOpenFormula.toString(this.getLogicalTableIDs())));
            }
            Category category = null;
            String[] tblcol = fieldName.split("\\.");
            if (tblcol.length != 2 && tblcol.length != 3) {
                throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0011_INVALID_FIELDNAME", fieldName));
            }
            LogicalColumn column = null;
            LogicalTable logicalTable = null;
            for (LogicalTable table : this.tables) {
                if (!table.getId().equalsIgnoreCase(tblcol[0])) continue;
                logicalTable = table;
                break;
            }
            if (logicalTable != null) {
                column = logicalTable.findLogicalColumn(tblcol[1]);
                if (column == null) {
                    throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0019_FIELDNAME_ERROR_CAT_COLUMN_NOT_FOUND", fieldName, tblcol[0], tblcol[1]));
                }
            } else {
                logicalTable = this.model.findLogicalTable(tblcol[0]);
                if (logicalTable == null) {
                    category = this.model.findCategory(tblcol[0]);
                    if (category == null) {
                        throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0012_FIELDNAME_ERROR_PARENT_NOT_FOUND", fieldName, tblcol[0]));
                    }
                    column = category.findLogicalColumn(tblcol[1]);
                    if (column == null) {
                        throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0010_FIELDNAME_ERROR_COLUMN_NOT_FOUND", fieldName, tblcol[1], tblcol[0]));
                    }
                } else {
                    column = logicalTable.findLogicalColumn(tblcol[1]);
                    if (column == null) {
                        throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0010_FIELDNAME_ERROR_COLUMN_NOT_FOUND", fieldName, tblcol[1], tblcol[0]));
                    }
                    this.tables.add(logicalTable);
                }
            }
            AggregationType aggsetting = null;
            if (tblcol.length == 3 && (aggregation = tblcol[2]) != null) {
                AggregationType setting = AggregationType.valueOf(aggregation.toUpperCase());
                if (column.getAggregationType() == setting || column.getAggregationList() != null && column.getAggregationList().contains((Object)setting)) {
                    aggsetting = setting;
                }
            }
            if (category == null) {
                logger.warn((Object)Messages.getErrorString("SqlOpenFormula.ERROR_0023_UNASSOCIATED_LOGICAL_COL", column.getId()));
                for (Category cat : this.model.getCategories()) {
                    if (cat.findLogicalColumn(column.getId()) == null) continue;
                    category = cat;
                    break;
                }
            }
            Selection selection = new Selection(category, column, aggsetting);
            this.selectionMap.put(fieldName, selection);
            this.selections.add(selection);
        }
    }

    public static String toString(Object[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndResolveObjectModel(Object val) throws PentahoMetadataException {
        if (val instanceof Term) {
            Term t = (Term)val;
            this.validateAndResolveObjectModel(t.getHeadValue());
            for (int i = 0; i < t.getOperators().length; ++i) {
                this.validateAndResolveObjectModel(t.getOperators()[i]);
                if (t.getOperands()[i] instanceof ContextLookup && this.paramContainsMultipleValues((ContextLookup)t.getOperands()[i])) {
                    throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0024_MULTIPLE_VALUES_NOT_SUPPORTED", t.getOperators()[i].toString()));
                }
                this.validateAndResolveObjectModel(t.getOperands()[i]);
            }
            return;
        } else if (val instanceof ContextLookup) {
            ContextLookup l = (ContextLookup)val;
            this.addField(l.getName());
            return;
        } else {
            if (val instanceof StaticValue) {
                return;
            }
            if (val instanceof FormulaFunction) {
                FormulaFunction f = (FormulaFunction)val;
                if (!this.sqlDialect.isSupportedFunction(f.getFunctionName())) throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0014_FUNCTION_NOT_SUPPORTED", f.getFunctionName()));
                SQLFunctionGeneratorInterface gen = this.sqlDialect.getFunctionSQLGenerator(f.getFunctionName());
                gen.validateFunction(f);
                if (!this.allowAggregateFunctions && this.tables == null && this.sqlDialect.isAggregateFunction(f.getFunctionName())) {
                    throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0013_AGGREGATE_USAGE_ERROR", f.getFunctionName(), this.formulaString));
                }
                if (this.sqlDialect.isAggregateFunction(f.getFunctionName())) {
                    this.hasAggregateFunction = true;
                }
                if (f.getChildValues() == null || f.getChildValues().length <= 0) return;
                this.validateAndResolveObjectModel(f.getChildValues()[0]);
                for (int i = 1; i < f.getChildValues().length; ++i) {
                    if (f.getChildValues()[i] instanceof ContextLookup && this.paramContainsMultipleValues((ContextLookup)f.getChildValues()[i]) && !gen.isMultiValuedParamAware()) {
                        throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0024_MULTIPLE_VALUES_NOT_SUPPORTED", f.getFunctionName()));
                    }
                    this.validateAndResolveObjectModel(f.getChildValues()[i]);
                }
                return;
            } else {
                if (val instanceof InfixOperator) {
                    if (!this.sqlDialect.isSupportedInfixOperator(val.toString())) throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0021_OPERATOR_NOT_SUPPORTED", val.toString()));
                    return;
                }
                if (!(val instanceof PrefixTerm)) throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0016_CLASS_TYPE_NOT_SUPPORTED", val.getClass().toString()));
                return;
            }
        }
    }

    private boolean paramContainsMultipleValues(ContextLookup contextLookup) {
        String fieldName = contextLookup.getName();
        if (!this.selectionMap.containsKey(fieldName) && fieldName.startsWith(PARAM)) {
            String paramName = fieldName.substring(6);
            if (this.parameters.containsKey(paramName)) {
                Object param = this.parameters.get(paramName);
                return param instanceof Object[] && ((Object[])param).length > 1;
            }
            return false;
        }
        return false;
    }

    public boolean requiresParens(Object parent, Object val) {
        boolean parentMatch = false;
        if (parent instanceof Term) {
            parentMatch = true;
        } else if (parent instanceof FormulaFunction) {
            FormulaFunction parentFunction = (FormulaFunction)parent;
            SQLFunctionGeneratorInterface parentGen = this.sqlDialect.getFunctionSQLGenerator(parentFunction.getFunctionName());
            boolean bl = parentMatch = parentGen.getType() == 0;
        }
        if (!parentMatch) {
            return false;
        }
        if (val instanceof InfixOperator) {
            return true;
        }
        if (val instanceof FormulaFunction) {
            FormulaFunction f = (FormulaFunction)val;
            SQLFunctionGeneratorInterface gen = this.sqlDialect.getFunctionSQLGenerator(f.getFunctionName());
            return gen.getType() == 0;
        }
        return false;
    }

    @Override
    public void generateSQL(Object parent, Object val, StringBuffer sb, String locale) throws PentahoMetadataException {
        if (val instanceof Term) {
            boolean addParens;
            Term t = (Term)val;
            boolean bl = addParens = t.getOperators().length > 1 || this.requiresParens(parent, t.getOperators()[0]);
            if (addParens) {
                sb.append("(");
            }
            this.generateSQL(t, t.getHeadValue(), sb, locale);
            for (int i = 0; i < t.getOperators().length; ++i) {
                this.generateSQL(t, t.getOperators()[i], sb, locale);
                this.generateSQL(t, t.getOperands()[i], sb, locale);
            }
            if (addParens) {
                sb.append(")");
            }
        } else if (val instanceof ContextLookup) {
            ContextLookup l = (ContextLookup)val;
            this.renderContextLookup(sb, l.getName(), locale);
        } else if (val instanceof StaticValue) {
            StaticValue v = (StaticValue)val;
            if (v.getValueType() instanceof TextType) {
                sb.append(this.sqlDialect.quoteStringLiteral(v.getValue()));
            } else {
                sb.append(v.getValue());
            }
        } else if (val instanceof FormulaFunction) {
            FormulaFunction f = (FormulaFunction)val;
            SQLFunctionGeneratorInterface gen = this.sqlDialect.getFunctionSQLGenerator(f.getFunctionName());
            boolean addParens = this.requiresParens(parent, f);
            if (addParens) {
                sb.append("(");
            }
            gen.generateFunctionSQL(this, sb, locale, f);
            if (addParens) {
                sb.append(")");
            }
        } else if (val instanceof InfixOperator) {
            if (this.sqlDialect.isSupportedInfixOperator(val.toString())) {
                SQLOperatorGeneratorInterface gen = this.sqlDialect.getInfixOperatorSQLGenerator(val.toString());
                sb.append(" " + gen.getOperatorSQL() + " ");
            }
        } else if (val instanceof PrefixTerm) {
            PrefixTerm v = (PrefixTerm)val;
            sb.append(v.toString());
        } else {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0016_CLASS_TYPE_NOT_SUPPORTED", val.getClass().toString()));
        }
    }

    @Override
    public Object getParameterValue(ContextLookup param) throws PentahoMetadataException {
        if (param.getName().startsWith(PARAM)) {
            String paramName = param.getName().substring(6);
            return this.parameters.get(paramName);
        }
        throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0022_INVALID_PARAM_REFERENCE", param.getName()));
    }

    protected void renderContextLookup(StringBuffer sb, String contextName, String locale) throws PentahoMetadataException {
        Selection column = this.selectionMap.get(contextName);
        if (column == null) {
            if (contextName.startsWith(PARAM)) {
                String paramName = contextName.substring(6);
                if (this.genAsPreparedStatement) {
                    sb.append("___PARAM[" + paramName + "]___");
                } else {
                    Object paramValue = this.parameters.get(paramName);
                    if (paramValue instanceof Boolean) {
                        if (((Boolean)paramValue).booleanValue()) {
                            this.sqlDialect.getFunctionSQLGenerator("TRUE").generateFunctionSQL(this, sb, locale, null);
                        } else {
                            this.sqlDialect.getFunctionSQLGenerator("FALSE").generateFunctionSQL(this, sb, locale, null);
                        }
                    } else if (paramValue instanceof Double) {
                        sb.append(paramValue.toString());
                    } else if (paramValue instanceof Double[]) {
                        Double[] param = (Double[])paramValue;
                        for (int i = 0; i < param.length; ++i) {
                            if (i != 0) {
                                sb.append(" , ");
                            }
                            sb.append(param[i].toString());
                        }
                    } else if (paramValue instanceof Object[]) {
                        Object[] param = (Object[])paramValue;
                        for (int i = 0; i < param.length; ++i) {
                            if (i != 0) {
                                sb.append(" , ");
                            }
                            sb.append(this.sqlDialect.quoteStringLiteral(param[i].toString()));
                        }
                    } else {
                        sb.append(this.sqlDialect.quoteStringLiteral(paramValue.toString()));
                    }
                }
                return;
            }
            String tableColumn = "";
            sb.append(" ");
            LogicalTable businessTable = this.findLogicalTableForContextName(contextName, locale);
            if (businessTable != null) {
                String tableAlias = null;
                tableAlias = this.tableAliases != null ? this.tableAliases.get(businessTable) : businessTable.getId();
                sb.append(this.databaseMeta.quoteField(tableAlias));
                sb.append(".");
            }
            sb.append(this.databaseMeta.quoteField(contextName));
            sb.append(" ");
        } else {
            sb.append(" ");
            SqlAndTables sqlAndTables = SqlGenerator.getBusinessColumnSQL(this.model, column, this.tableAliases, this.parameters, this.genAsPreparedStatement, this.databaseMeta, locale);
            sb.append(sqlAndTables.getSql());
            sb.append(" ");
            for (LogicalTable businessTable : sqlAndTables.getUsedTables()) {
                if (this.tables.contains(businessTable)) continue;
                this.tables.add(businessTable);
            }
        }
    }

    public String generateSQL(String locale) throws PentahoMetadataException {
        if (!this.isValidated) {
            throw new PentahoMetadataException(Messages.getErrorString("SqlOpenFormula.ERROR_0017_STATE_ERROR_NOT_VALIDATED", new Object[0]));
        }
        StringBuffer sb = new StringBuffer();
        this.generateSQL(null, this.formulaObject.getRootReference(), sb, locale);
        return sb.toString();
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public String[] getLogicalTableIDs() {
        String[] names = new String[this.tables.size()];
        for (int i = 0; i < this.tables.size(); ++i) {
            names[i] = this.tables.get(i).getId();
        }
        return names;
    }

    public boolean hasAggregateFunction() {
        return this.hasAggregateFunction;
    }

    public void setAllowAggregateFunctions(boolean allowAggregateFunctions) {
        this.allowAggregateFunctions = allowAggregateFunctions;
    }

    protected LogicalTable findLogicalTableForContextName(String contextName, String locale) {
        LogicalTable businessTable = null;
        for (LogicalTable table : this.getLogicalTables()) {
            LogicalColumn c = table.findLogicalColumn(contextName);
            if (c == null) {
                for (LogicalColumn col : table.getLogicalColumns()) {
                    LocalizedString name = col.getName();
                    if (name == null || !contextName.equals(name.getString(locale))) continue;
                    c = col;
                    break;
                }
            }
            for (LogicalColumn col : table.getLogicalColumns()) {
                if (!contextName.equals(col.getProperty("target_column"))) continue;
                c = col;
                break;
            }
            if (c == null) continue;
            businessTable = c.getLogicalTable();
        }
        return businessTable;
    }

    public boolean hasAggregate() {
        if (this.hasAgg == null) {
            this.hasAgg = Boolean.FALSE;
            for (Selection col : this.getSelections()) {
                if (!col.hasAggregate()) continue;
                this.hasAgg = Boolean.TRUE;
                return this.hasAgg;
            }
        }
        return this.hasAgg;
    }
}

